package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  RoleArn,
  DataSourceName,
  DataSourceId,
  LanguageCode,
  IndexId,
  Description,
  ScanSchedule
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateDataSourceRequest(
    id: DataSourceId,
    name: Option[DataSourceName] = None,
    indexId: IndexId,
    configuration: Option[zio.aws.kendra.model.DataSourceConfiguration] = None,
    description: Option[Description] = None,
    schedule: Option[ScanSchedule] = None,
    roleArn: Option[RoleArn] = None,
    languageCode: Option[LanguageCode] = None,
    customDocumentEnrichmentConfiguration: Option[
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.UpdateDataSourceRequest = {
    import UpdateDataSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.UpdateDataSourceRequest
      .builder()
      .id(DataSourceId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => DataSourceName.unwrap(value): java.lang.String)
      )(_.name)
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        schedule.map(value => ScanSchedule.unwrap(value): java.lang.String)
      )(_.schedule)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        languageCode.map(value => LanguageCode.unwrap(value): java.lang.String)
      )(_.languageCode)
      .optionallyWith(
        customDocumentEnrichmentConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.customDocumentEnrichmentConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.UpdateDataSourceRequest.ReadOnly =
    zio.aws.kendra.model.UpdateDataSourceRequest.wrap(buildAwsValue())
}
object UpdateDataSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.UpdateDataSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.UpdateDataSourceRequest =
      zio.aws.kendra.model.UpdateDataSourceRequest(
        id,
        name.map(value => value),
        indexId,
        configuration.map(value => value.asEditable),
        description.map(value => value),
        schedule.map(value => value),
        roleArn.map(value => value),
        languageCode.map(value => value),
        customDocumentEnrichmentConfiguration.map(value => value.asEditable)
      )
    def id: DataSourceId
    def name: Option[DataSourceName]
    def indexId: IndexId
    def configuration
        : Option[zio.aws.kendra.model.DataSourceConfiguration.ReadOnly]
    def description: Option[Description]
    def schedule: Option[ScanSchedule]
    def roleArn: Option[RoleArn]
    def languageCode: Option[LanguageCode]
    def customDocumentEnrichmentConfiguration: Option[
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.ReadOnly
    ]
    def getId: ZIO[Any, Nothing, DataSourceId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, DataSourceName] =
      AwsError.unwrapOptionField("name", name)
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DataSourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSchedule: ZIO[Any, AwsError, ScanSchedule] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getLanguageCode: ZIO[Any, AwsError, LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getCustomDocumentEnrichmentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "customDocumentEnrichmentConfiguration",
      customDocumentEnrichmentConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.UpdateDataSourceRequest
  ) extends zio.aws.kendra.model.UpdateDataSourceRequest.ReadOnly {
    override val id: DataSourceId =
      zio.aws.kendra.model.primitives.DataSourceId(impl.id())
    override val name: Option[DataSourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.kendra.model.primitives.DataSourceName(value))
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val configuration
        : Option[zio.aws.kendra.model.DataSourceConfiguration.ReadOnly] = scala
      .Option(impl.configuration())
      .map(value => zio.aws.kendra.model.DataSourceConfiguration.wrap(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val schedule: Option[ScanSchedule] = scala
      .Option(impl.schedule())
      .map(value => zio.aws.kendra.model.primitives.ScanSchedule(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
    override val languageCode: Option[LanguageCode] = scala
      .Option(impl.languageCode())
      .map(value => zio.aws.kendra.model.primitives.LanguageCode(value))
    override val customDocumentEnrichmentConfiguration: Option[
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.ReadOnly
    ] = scala
      .Option(impl.customDocumentEnrichmentConfiguration())
      .map(value =>
        zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.UpdateDataSourceRequest
  ): zio.aws.kendra.model.UpdateDataSourceRequest.ReadOnly = new Wrapper(impl)
}
