package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  ExperienceName,
  ExperienceId,
  RoleArn,
  IndexId,
  Description
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateExperienceRequest(
    id: ExperienceId,
    name: Option[ExperienceName] = None,
    indexId: IndexId,
    roleArn: Option[RoleArn] = None,
    configuration: Option[zio.aws.kendra.model.ExperienceConfiguration] = None,
    description: Option[Description] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.UpdateExperienceRequest = {
    import UpdateExperienceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.UpdateExperienceRequest
      .builder()
      .id(ExperienceId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => ExperienceName.unwrap(value): java.lang.String)
      )(_.name)
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.UpdateExperienceRequest.ReadOnly =
    zio.aws.kendra.model.UpdateExperienceRequest.wrap(buildAwsValue())
}
object UpdateExperienceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.UpdateExperienceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.UpdateExperienceRequest =
      zio.aws.kendra.model.UpdateExperienceRequest(
        id,
        name.map(value => value),
        indexId,
        roleArn.map(value => value),
        configuration.map(value => value.asEditable),
        description.map(value => value)
      )
    def id: ExperienceId
    def name: Option[ExperienceName]
    def indexId: IndexId
    def roleArn: Option[RoleArn]
    def configuration
        : Option[zio.aws.kendra.model.ExperienceConfiguration.ReadOnly]
    def description: Option[Description]
    def getId: ZIO[Any, Nothing, ExperienceId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, ExperienceName] =
      AwsError.unwrapOptionField("name", name)
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.ExperienceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.UpdateExperienceRequest
  ) extends zio.aws.kendra.model.UpdateExperienceRequest.ReadOnly {
    override val id: ExperienceId =
      zio.aws.kendra.model.primitives.ExperienceId(impl.id())
    override val name: Option[ExperienceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.kendra.model.primitives.ExperienceName(value))
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
    override val configuration
        : Option[zio.aws.kendra.model.ExperienceConfiguration.ReadOnly] = scala
      .Option(impl.configuration())
      .map(value => zio.aws.kendra.model.ExperienceConfiguration.wrap(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.UpdateExperienceRequest
  ): zio.aws.kendra.model.UpdateExperienceRequest.ReadOnly = new Wrapper(impl)
}
