package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  Description,
  RoleArn,
  IndexName,
  IndexId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateIndexRequest(
    id: IndexId,
    name: Option[IndexName] = None,
    roleArn: Option[RoleArn] = None,
    description: Option[Description] = None,
    documentMetadataConfigurationUpdates: Option[
      Iterable[zio.aws.kendra.model.DocumentMetadataConfiguration]
    ] = None,
    capacityUnits: Option[zio.aws.kendra.model.CapacityUnitsConfiguration] =
      None,
    userTokenConfigurations: Option[
      Iterable[zio.aws.kendra.model.UserTokenConfiguration]
    ] = None,
    userContextPolicy: Option[zio.aws.kendra.model.UserContextPolicy] = None,
    userGroupResolutionConfiguration: Option[
      zio.aws.kendra.model.UserGroupResolutionConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.UpdateIndexRequest = {
    import UpdateIndexRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.UpdateIndexRequest
      .builder()
      .id(IndexId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        documentMetadataConfigurationUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentMetadataConfigurationUpdates)
      .optionallyWith(capacityUnits.map(value => value.buildAwsValue()))(
        _.capacityUnits
      )
      .optionallyWith(
        userTokenConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userTokenConfigurations)
      .optionallyWith(userContextPolicy.map(value => value.unwrap))(
        _.userContextPolicy
      )
      .optionallyWith(
        userGroupResolutionConfiguration.map(value => value.buildAwsValue())
      )(_.userGroupResolutionConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.UpdateIndexRequest.ReadOnly =
    zio.aws.kendra.model.UpdateIndexRequest.wrap(buildAwsValue())
}
object UpdateIndexRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.UpdateIndexRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.UpdateIndexRequest =
      zio.aws.kendra.model.UpdateIndexRequest(
        id,
        name.map(value => value),
        roleArn.map(value => value),
        description.map(value => value),
        documentMetadataConfigurationUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        capacityUnits.map(value => value.asEditable),
        userTokenConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userContextPolicy.map(value => value),
        userGroupResolutionConfiguration.map(value => value.asEditable)
      )
    def id: IndexId
    def name: Option[IndexName]
    def roleArn: Option[RoleArn]
    def description: Option[Description]
    def documentMetadataConfigurationUpdates: Option[
      List[zio.aws.kendra.model.DocumentMetadataConfiguration.ReadOnly]
    ]
    def capacityUnits
        : Option[zio.aws.kendra.model.CapacityUnitsConfiguration.ReadOnly]
    def userTokenConfigurations
        : Option[List[zio.aws.kendra.model.UserTokenConfiguration.ReadOnly]]
    def userContextPolicy: Option[zio.aws.kendra.model.UserContextPolicy]
    def userGroupResolutionConfiguration
        : Option[zio.aws.kendra.model.UserGroupResolutionConfiguration.ReadOnly]
    def getId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("name", name)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDocumentMetadataConfigurationUpdates: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DocumentMetadataConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "documentMetadataConfigurationUpdates",
      documentMetadataConfigurationUpdates
    )
    def getCapacityUnits: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.CapacityUnitsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("capacityUnits", capacityUnits)
    def getUserTokenConfigurations: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.UserTokenConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "userTokenConfigurations",
      userTokenConfigurations
    )
    def getUserContextPolicy
        : ZIO[Any, AwsError, zio.aws.kendra.model.UserContextPolicy] =
      AwsError.unwrapOptionField("userContextPolicy", userContextPolicy)
    def getUserGroupResolutionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.UserGroupResolutionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "userGroupResolutionConfiguration",
      userGroupResolutionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.UpdateIndexRequest
  ) extends zio.aws.kendra.model.UpdateIndexRequest.ReadOnly {
    override val id: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.id())
    override val name: Option[IndexName] = scala
      .Option(impl.name())
      .map(value => zio.aws.kendra.model.primitives.IndexName(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val documentMetadataConfigurationUpdates: Option[
      List[zio.aws.kendra.model.DocumentMetadataConfiguration.ReadOnly]
    ] = scala
      .Option(impl.documentMetadataConfigurationUpdates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DocumentMetadataConfiguration.wrap(item)
        }.toList
      )
    override val capacityUnits
        : Option[zio.aws.kendra.model.CapacityUnitsConfiguration.ReadOnly] =
      scala
        .Option(impl.capacityUnits())
        .map(value =>
          zio.aws.kendra.model.CapacityUnitsConfiguration.wrap(value)
        )
    override val userTokenConfigurations
        : Option[List[zio.aws.kendra.model.UserTokenConfiguration.ReadOnly]] =
      scala
        .Option(impl.userTokenConfigurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.UserTokenConfiguration.wrap(item)
          }.toList
        )
    override val userContextPolicy
        : Option[zio.aws.kendra.model.UserContextPolicy] = scala
      .Option(impl.userContextPolicy())
      .map(value => zio.aws.kendra.model.UserContextPolicy.wrap(value))
    override val userGroupResolutionConfiguration: Option[
      zio.aws.kendra.model.UserGroupResolutionConfiguration.ReadOnly
    ] = scala
      .Option(impl.userGroupResolutionConfiguration())
      .map(value =>
        zio.aws.kendra.model.UserGroupResolutionConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.UpdateIndexRequest
  ): zio.aws.kendra.model.UpdateIndexRequest.ReadOnly = new Wrapper(impl)
}
