package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  RoleArn,
  IndexId,
  Description,
  QuerySuggestionsBlockListName,
  QuerySuggestionsBlockListId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateQuerySuggestionsBlockListRequest(
    indexId: IndexId,
    id: QuerySuggestionsBlockListId,
    name: Option[QuerySuggestionsBlockListName] = None,
    description: Option[Description] = None,
    sourceS3Path: Option[zio.aws.kendra.model.S3Path] = None,
    roleArn: Option[RoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsBlockListRequest = {
    import UpdateQuerySuggestionsBlockListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsBlockListRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .id(QuerySuggestionsBlockListId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value =>
          QuerySuggestionsBlockListName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(sourceS3Path.map(value => value.buildAwsValue()))(
        _.sourceS3Path
      )
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.UpdateQuerySuggestionsBlockListRequest.ReadOnly =
    zio.aws.kendra.model.UpdateQuerySuggestionsBlockListRequest
      .wrap(buildAwsValue())
}
object UpdateQuerySuggestionsBlockListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsBlockListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.UpdateQuerySuggestionsBlockListRequest =
      zio.aws.kendra.model.UpdateQuerySuggestionsBlockListRequest(
        indexId,
        id,
        name.map(value => value),
        description.map(value => value),
        sourceS3Path.map(value => value.asEditable),
        roleArn.map(value => value)
      )
    def indexId: IndexId
    def id: QuerySuggestionsBlockListId
    def name: Option[QuerySuggestionsBlockListName]
    def description: Option[Description]
    def sourceS3Path: Option[zio.aws.kendra.model.S3Path.ReadOnly]
    def roleArn: Option[RoleArn]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getId: ZIO[Any, Nothing, QuerySuggestionsBlockListId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, QuerySuggestionsBlockListName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSourceS3Path
        : ZIO[Any, AwsError, zio.aws.kendra.model.S3Path.ReadOnly] =
      AwsError.unwrapOptionField("sourceS3Path", sourceS3Path)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsBlockListRequest
  ) extends zio.aws.kendra.model.UpdateQuerySuggestionsBlockListRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val id: QuerySuggestionsBlockListId =
      zio.aws.kendra.model.primitives.QuerySuggestionsBlockListId(impl.id())
    override val name: Option[QuerySuggestionsBlockListName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.kendra.model.primitives.QuerySuggestionsBlockListName(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val sourceS3Path: Option[zio.aws.kendra.model.S3Path.ReadOnly] =
      scala
        .Option(impl.sourceS3Path())
        .map(value => zio.aws.kendra.model.S3Path.wrap(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.UpdateQuerySuggestionsBlockListRequest
  ): zio.aws.kendra.model.UpdateQuerySuggestionsBlockListRequest.ReadOnly =
    new Wrapper(impl)
}
