package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  RoleArn,
  IndexId,
  Description,
  ThesaurusName,
  ThesaurusId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateThesaurusRequest(
    id: ThesaurusId,
    name: Option[ThesaurusName] = None,
    indexId: IndexId,
    description: Option[Description] = None,
    roleArn: Option[RoleArn] = None,
    sourceS3Path: Option[zio.aws.kendra.model.S3Path] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.UpdateThesaurusRequest = {
    import UpdateThesaurusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.UpdateThesaurusRequest
      .builder()
      .id(ThesaurusId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => ThesaurusName.unwrap(value): java.lang.String)
      )(_.name)
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(sourceS3Path.map(value => value.buildAwsValue()))(
        _.sourceS3Path
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.UpdateThesaurusRequest.ReadOnly =
    zio.aws.kendra.model.UpdateThesaurusRequest.wrap(buildAwsValue())
}
object UpdateThesaurusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.UpdateThesaurusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.UpdateThesaurusRequest =
      zio.aws.kendra.model.UpdateThesaurusRequest(
        id,
        name.map(value => value),
        indexId,
        description.map(value => value),
        roleArn.map(value => value),
        sourceS3Path.map(value => value.asEditable)
      )
    def id: ThesaurusId
    def name: Option[ThesaurusName]
    def indexId: IndexId
    def description: Option[Description]
    def roleArn: Option[RoleArn]
    def sourceS3Path: Option[zio.aws.kendra.model.S3Path.ReadOnly]
    def getId: ZIO[Any, Nothing, ThesaurusId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, ThesaurusName] =
      AwsError.unwrapOptionField("name", name)
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getSourceS3Path
        : ZIO[Any, AwsError, zio.aws.kendra.model.S3Path.ReadOnly] =
      AwsError.unwrapOptionField("sourceS3Path", sourceS3Path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.UpdateThesaurusRequest
  ) extends zio.aws.kendra.model.UpdateThesaurusRequest.ReadOnly {
    override val id: ThesaurusId =
      zio.aws.kendra.model.primitives.ThesaurusId(impl.id())
    override val name: Option[ThesaurusName] = scala
      .Option(impl.name())
      .map(value => zio.aws.kendra.model.primitives.ThesaurusName(value))
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
    override val sourceS3Path: Option[zio.aws.kendra.model.S3Path.ReadOnly] =
      scala
        .Option(impl.sourceS3Path())
        .map(value => zio.aws.kendra.model.S3Path.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.UpdateThesaurusRequest
  ): zio.aws.kendra.model.UpdateThesaurusRequest.ReadOnly = new Wrapper(impl)
}
