package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.WarningMessage
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Warning(
    message: Option[WarningMessage] = None,
    code: Option[zio.aws.kendra.model.WarningCode] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.kendra.model.Warning = {
    import Warning.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.Warning
      .builder()
      .optionallyWith(
        message.map(value => WarningMessage.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.Warning.ReadOnly =
    zio.aws.kendra.model.Warning.wrap(buildAwsValue())
}
object Warning {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kendra.model.Warning] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.Warning = zio.aws.kendra.model
      .Warning(message.map(value => value), code.map(value => value))
    def message: Option[WarningMessage]
    def code: Option[zio.aws.kendra.model.WarningCode]
    def getMessage: ZIO[Any, AwsError, WarningMessage] =
      AwsError.unwrapOptionField("message", message)
    def getCode: ZIO[Any, AwsError, zio.aws.kendra.model.WarningCode] =
      AwsError.unwrapOptionField("code", code)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.Warning
  ) extends zio.aws.kendra.model.Warning.ReadOnly {
    override val message: Option[WarningMessage] = scala
      .Option(impl.message())
      .map(value => zio.aws.kendra.model.primitives.WarningMessage(value))
    override val code: Option[zio.aws.kendra.model.WarningCode] = scala
      .Option(impl.code())
      .map(value => zio.aws.kendra.model.WarningCode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.Warning
  ): zio.aws.kendra.model.Warning.ReadOnly = new Wrapper(impl)
}
