package zio.aws.kendra.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  CrawlDepth,
  MaxLinksPerPage,
  MaxContentSizePerPageInMegaBytes,
  MaxUrlsPerMinuteCrawlRate,
  DataSourceInclusionsExclusionsStringsMember
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class WebCrawlerConfiguration(
    urls: zio.aws.kendra.model.Urls,
    crawlDepth: Option[CrawlDepth] = None,
    maxLinksPerPage: Option[MaxLinksPerPage] = None,
    maxContentSizePerPageInMegaBytes: Option[MaxContentSizePerPageInMegaBytes] =
      None,
    maxUrlsPerMinuteCrawlRate: Option[MaxUrlsPerMinuteCrawlRate] = None,
    urlInclusionPatterns: Option[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = None,
    urlExclusionPatterns: Option[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = None,
    proxyConfiguration: Option[zio.aws.kendra.model.ProxyConfiguration] = None,
    authenticationConfiguration: Option[
      zio.aws.kendra.model.AuthenticationConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.WebCrawlerConfiguration = {
    import WebCrawlerConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.WebCrawlerConfiguration
      .builder()
      .urls(urls.buildAwsValue())
      .optionallyWith(
        crawlDepth.map(value => CrawlDepth.unwrap(value): Integer)
      )(_.crawlDepth)
      .optionallyWith(
        maxLinksPerPage.map(value => MaxLinksPerPage.unwrap(value): Integer)
      )(_.maxLinksPerPage)
      .optionallyWith(
        maxContentSizePerPageInMegaBytes.map(value =>
          MaxContentSizePerPageInMegaBytes.unwrap(value): java.lang.Float
        )
      )(_.maxContentSizePerPageInMegaBytes)
      .optionallyWith(
        maxUrlsPerMinuteCrawlRate.map(value =>
          MaxUrlsPerMinuteCrawlRate.unwrap(value): Integer
        )
      )(_.maxUrlsPerMinuteCrawlRate)
      .optionallyWith(
        urlInclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.urlInclusionPatterns)
      .optionallyWith(
        urlExclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.urlExclusionPatterns)
      .optionallyWith(proxyConfiguration.map(value => value.buildAwsValue()))(
        _.proxyConfiguration
      )
      .optionallyWith(
        authenticationConfiguration.map(value => value.buildAwsValue())
      )(_.authenticationConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.WebCrawlerConfiguration.ReadOnly =
    zio.aws.kendra.model.WebCrawlerConfiguration.wrap(buildAwsValue())
}
object WebCrawlerConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.WebCrawlerConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.WebCrawlerConfiguration =
      zio.aws.kendra.model.WebCrawlerConfiguration(
        urls.asEditable,
        crawlDepth.map(value => value),
        maxLinksPerPage.map(value => value),
        maxContentSizePerPageInMegaBytes.map(value => value),
        maxUrlsPerMinuteCrawlRate.map(value => value),
        urlInclusionPatterns.map(value => value),
        urlExclusionPatterns.map(value => value),
        proxyConfiguration.map(value => value.asEditable),
        authenticationConfiguration.map(value => value.asEditable)
      )
    def urls: zio.aws.kendra.model.Urls.ReadOnly
    def crawlDepth: Option[CrawlDepth]
    def maxLinksPerPage: Option[MaxLinksPerPage]
    def maxContentSizePerPageInMegaBytes
        : Option[MaxContentSizePerPageInMegaBytes]
    def maxUrlsPerMinuteCrawlRate: Option[MaxUrlsPerMinuteCrawlRate]
    def urlInclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]]
    def urlExclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]]
    def proxyConfiguration
        : Option[zio.aws.kendra.model.ProxyConfiguration.ReadOnly]
    def authenticationConfiguration
        : Option[zio.aws.kendra.model.AuthenticationConfiguration.ReadOnly]
    def getUrls: ZIO[Any, Nothing, zio.aws.kendra.model.Urls.ReadOnly] =
      ZIO.succeed(urls)
    def getCrawlDepth: ZIO[Any, AwsError, CrawlDepth] =
      AwsError.unwrapOptionField("crawlDepth", crawlDepth)
    def getMaxLinksPerPage: ZIO[Any, AwsError, MaxLinksPerPage] =
      AwsError.unwrapOptionField("maxLinksPerPage", maxLinksPerPage)
    def getMaxContentSizePerPageInMegaBytes
        : ZIO[Any, AwsError, MaxContentSizePerPageInMegaBytes] =
      AwsError.unwrapOptionField(
        "maxContentSizePerPageInMegaBytes",
        maxContentSizePerPageInMegaBytes
      )
    def getMaxUrlsPerMinuteCrawlRate
        : ZIO[Any, AwsError, MaxUrlsPerMinuteCrawlRate] = AwsError
      .unwrapOptionField("maxUrlsPerMinuteCrawlRate", maxUrlsPerMinuteCrawlRate)
    def getUrlInclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] =
      AwsError.unwrapOptionField("urlInclusionPatterns", urlInclusionPatterns)
    def getUrlExclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] =
      AwsError.unwrapOptionField("urlExclusionPatterns", urlExclusionPatterns)
    def getProxyConfiguration
        : ZIO[Any, AwsError, zio.aws.kendra.model.ProxyConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("proxyConfiguration", proxyConfiguration)
    def getAuthenticationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.AuthenticationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "authenticationConfiguration",
      authenticationConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.WebCrawlerConfiguration
  ) extends zio.aws.kendra.model.WebCrawlerConfiguration.ReadOnly {
    override val urls: zio.aws.kendra.model.Urls.ReadOnly =
      zio.aws.kendra.model.Urls.wrap(impl.urls())
    override val crawlDepth: Option[CrawlDepth] = scala
      .Option(impl.crawlDepth())
      .map(value => zio.aws.kendra.model.primitives.CrawlDepth(value))
    override val maxLinksPerPage: Option[MaxLinksPerPage] = scala
      .Option(impl.maxLinksPerPage())
      .map(value => zio.aws.kendra.model.primitives.MaxLinksPerPage(value))
    override val maxContentSizePerPageInMegaBytes
        : Option[MaxContentSizePerPageInMegaBytes] = scala
      .Option(impl.maxContentSizePerPageInMegaBytes())
      .map(value =>
        zio.aws.kendra.model.primitives.MaxContentSizePerPageInMegaBytes(value)
      )
    override val maxUrlsPerMinuteCrawlRate: Option[MaxUrlsPerMinuteCrawlRate] =
      scala
        .Option(impl.maxUrlsPerMinuteCrawlRate())
        .map(value =>
          zio.aws.kendra.model.primitives.MaxUrlsPerMinuteCrawlRate(value)
        )
    override val urlInclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]] = scala
      .Option(impl.urlInclusionPatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives
            .DataSourceInclusionsExclusionsStringsMember(item)
        }.toList
      )
    override val urlExclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]] = scala
      .Option(impl.urlExclusionPatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives
            .DataSourceInclusionsExclusionsStringsMember(item)
        }.toList
      )
    override val proxyConfiguration
        : Option[zio.aws.kendra.model.ProxyConfiguration.ReadOnly] = scala
      .Option(impl.proxyConfiguration())
      .map(value => zio.aws.kendra.model.ProxyConfiguration.wrap(value))
    override val authenticationConfiguration
        : Option[zio.aws.kendra.model.AuthenticationConfiguration.ReadOnly] =
      scala
        .Option(impl.authenticationConfiguration())
        .map(value =>
          zio.aws.kendra.model.AuthenticationConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.WebCrawlerConfiguration
  ): zio.aws.kendra.model.WebCrawlerConfiguration.ReadOnly = new Wrapper(impl)
}
