package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  DataSourceInclusionsExclusionsStringsMember,
  OrganizationId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class WorkDocsConfiguration(
    organizationId: OrganizationId,
    crawlComments: Option[Boolean] = None,
    useChangeLog: Option[Boolean] = None,
    inclusionPatterns: Option[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = None,
    exclusionPatterns: Option[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = None,
    fieldMappings: Option[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.WorkDocsConfiguration = {
    import WorkDocsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.WorkDocsConfiguration
      .builder()
      .organizationId(OrganizationId.unwrap(organizationId): java.lang.String)
      .optionallyWith(crawlComments.map(value => value: java.lang.Boolean))(
        _.crawlComments
      )
      .optionallyWith(useChangeLog.map(value => value: java.lang.Boolean))(
        _.useChangeLog
      )
      .optionallyWith(
        inclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.inclusionPatterns)
      .optionallyWith(
        exclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.exclusionPatterns)
      .optionallyWith(
        fieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fieldMappings)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.WorkDocsConfiguration.ReadOnly =
    zio.aws.kendra.model.WorkDocsConfiguration.wrap(buildAwsValue())
}
object WorkDocsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.WorkDocsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.WorkDocsConfiguration =
      zio.aws.kendra.model.WorkDocsConfiguration(
        organizationId,
        crawlComments.map(value => value),
        useChangeLog.map(value => value),
        inclusionPatterns.map(value => value),
        exclusionPatterns.map(value => value),
        fieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def organizationId: OrganizationId
    def crawlComments: Option[Boolean]
    def useChangeLog: Option[Boolean]
    def inclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]]
    def exclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]]
    def fieldMappings: Option[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def getOrganizationId: ZIO[Any, Nothing, OrganizationId] =
      ZIO.succeed(organizationId)
    def getCrawlComments: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crawlComments", crawlComments)
    def getUseChangeLog: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("useChangeLog", useChangeLog)
    def getInclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("inclusionPatterns", inclusionPatterns)
    def getExclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("exclusionPatterns", exclusionPatterns)
    def getFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("fieldMappings", fieldMappings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.WorkDocsConfiguration
  ) extends zio.aws.kendra.model.WorkDocsConfiguration.ReadOnly {
    override val organizationId: OrganizationId =
      zio.aws.kendra.model.primitives.OrganizationId(impl.organizationId())
    override val crawlComments: Option[Boolean] =
      scala.Option(impl.crawlComments()).map(value => value: Boolean)
    override val useChangeLog: Option[Boolean] =
      scala.Option(impl.useChangeLog()).map(value => value: Boolean)
    override val inclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]] = scala
      .Option(impl.inclusionPatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives
            .DataSourceInclusionsExclusionsStringsMember(item)
        }.toList
      )
    override val exclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]] = scala
      .Option(impl.exclusionPatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives
            .DataSourceInclusionsExclusionsStringsMember(item)
        }.toList
      )
    override val fieldMappings: Option[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = scala
      .Option(impl.fieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.WorkDocsConfiguration
  ): zio.aws.kendra.model.WorkDocsConfiguration.ReadOnly = new Wrapper(impl)
}
