package zio.aws.kendra
import zio.aws.kendra.model.primitives.LambdaArn.Type
import java.time.Instant
import zio.aws.kendra.model.primitives.{
  SubnetId,
  MimeType,
  DataSourceId,
  ConfluenceSpaceIdentifier,
  FaqId,
  Importance,
  Url,
  ValueImportanceMapKey,
  UserAccount,
  SharedDriveId,
  ColumnName,
  SiteMap,
  DataSourceInclusionsExclusionsStringsMember,
  EntityId,
  VpcSecurityGroupId,
  OneDriveUser,
  SeedUrl,
  PrincipalName,
  DocumentAttributeKey,
  DocumentId,
  TagKey
}
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AmazonResourceName extends Subtype[String]
    type AmazonResourceName =
      zio.aws.kendra.model.primitives.AmazonResourceName.Type
    object Blob extends Subtype[Chunk[Byte]]
    type Blob = zio.aws.kendra.model.primitives.Blob.Type
    object ClaimRegex extends Subtype[String]
    type ClaimRegex = zio.aws.kendra.model.primitives.ClaimRegex.Type
    object ClientTokenName extends Subtype[String]
    type ClientTokenName = zio.aws.kendra.model.primitives.ClientTokenName.Type
    object ColumnName extends Subtype[String]
    type ColumnName = zio.aws.kendra.model.primitives.ColumnName.Type
    object ConfluenceSpaceIdentifier extends Subtype[String]
    type ConfluenceSpaceIdentifier =
      zio.aws.kendra.model.primitives.ConfluenceSpaceIdentifier.Type
    object CrawlDepth extends Subtype[Int]
    type CrawlDepth = zio.aws.kendra.model.primitives.CrawlDepth.Type
    object DataSourceDateFieldFormat extends Subtype[String]
    type DataSourceDateFieldFormat =
      zio.aws.kendra.model.primitives.DataSourceDateFieldFormat.Type
    object DataSourceFieldName extends Subtype[String]
    type DataSourceFieldName =
      zio.aws.kendra.model.primitives.DataSourceFieldName.Type
    object DataSourceId extends Subtype[String]
    type DataSourceId = zio.aws.kendra.model.primitives.DataSourceId.Type
    object DataSourceInclusionsExclusionsStringsMember extends Subtype[String]
    type DataSourceInclusionsExclusionsStringsMember =
      zio.aws.kendra.model.primitives.DataSourceInclusionsExclusionsStringsMember.Type
    object DataSourceName extends Subtype[String]
    type DataSourceName = zio.aws.kendra.model.primitives.DataSourceName.Type
    object DataSourceSyncJobId extends Subtype[String]
    type DataSourceSyncJobId =
      zio.aws.kendra.model.primitives.DataSourceSyncJobId.Type
    object DatabaseHost extends Subtype[String]
    type DatabaseHost = zio.aws.kendra.model.primitives.DatabaseHost.Type
    object DatabaseName extends Subtype[String]
    type DatabaseName = zio.aws.kendra.model.primitives.DatabaseName.Type
    object DatabasePort extends Subtype[Int]
    type DatabasePort = zio.aws.kendra.model.primitives.DatabasePort.Type
    object Description extends Subtype[String]
    type Description = zio.aws.kendra.model.primitives.Description.Type
    object DocumentAttributeKey extends Subtype[String]
    type DocumentAttributeKey =
      zio.aws.kendra.model.primitives.DocumentAttributeKey.Type
    object DocumentAttributeStringValue extends Subtype[String]
    type DocumentAttributeStringValue =
      zio.aws.kendra.model.primitives.DocumentAttributeStringValue.Type
    object DocumentId extends Subtype[String]
    type DocumentId = zio.aws.kendra.model.primitives.DocumentId.Type
    object DocumentMetadataBoolean extends Subtype[Boolean]
    type DocumentMetadataBoolean =
      zio.aws.kendra.model.primitives.DocumentMetadataBoolean.Type
    object DocumentMetadataConfigurationName extends Subtype[String]
    type DocumentMetadataConfigurationName =
      zio.aws.kendra.model.primitives.DocumentMetadataConfigurationName.Type
    object Duration extends Subtype[String]
    type Duration = zio.aws.kendra.model.primitives.Duration.Type
    object Endpoint extends Subtype[String]
    type Endpoint = zio.aws.kendra.model.primitives.Endpoint.Type
    object EntityId extends Subtype[String]
    type EntityId = zio.aws.kendra.model.primitives.EntityId.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.kendra.model.primitives.ErrorMessage.Type
    object ExperienceId extends Subtype[String]
    type ExperienceId = zio.aws.kendra.model.primitives.ExperienceId.Type
    object ExperienceName extends Subtype[String]
    type ExperienceName = zio.aws.kendra.model.primitives.ExperienceName.Type
    object FailureReason extends Subtype[String]
    type FailureReason = zio.aws.kendra.model.primitives.FailureReason.Type
    object FaqId extends Subtype[String]
    type FaqId = zio.aws.kendra.model.primitives.FaqId.Type
    object FaqName extends Subtype[String]
    type FaqName = zio.aws.kendra.model.primitives.FaqName.Type
    object FeedbackToken extends Subtype[String]
    type FeedbackToken = zio.aws.kendra.model.primitives.FeedbackToken.Type
    object FileSystemId extends Subtype[String]
    type FileSystemId = zio.aws.kendra.model.primitives.FileSystemId.Type
    object GroupAttributeField extends Subtype[String]
    type GroupAttributeField =
      zio.aws.kendra.model.primitives.GroupAttributeField.Type
    object GroupId extends Subtype[String]
    type GroupId = zio.aws.kendra.model.primitives.GroupId.Type
    object Host extends Subtype[String]
    type Host = zio.aws.kendra.model.primitives.Host.Type
    object IdentityAttributeName extends Subtype[String]
    type IdentityAttributeName =
      zio.aws.kendra.model.primitives.IdentityAttributeName.Type
    object Importance extends Subtype[Int]
    type Importance = zio.aws.kendra.model.primitives.Importance.Type
    object IndexFieldName extends Subtype[String]
    type IndexFieldName = zio.aws.kendra.model.primitives.IndexFieldName.Type
    object IndexId extends Subtype[String]
    type IndexId = zio.aws.kendra.model.primitives.IndexId.Type
    object IndexName extends Subtype[String]
    type IndexName = zio.aws.kendra.model.primitives.IndexName.Type
    object IndexedQuestionAnswersCount extends Subtype[Int]
    type IndexedQuestionAnswersCount =
      zio.aws.kendra.model.primitives.IndexedQuestionAnswersCount.Type
    object IndexedTextBytes extends Subtype[Long]
    type IndexedTextBytes =
      zio.aws.kendra.model.primitives.IndexedTextBytes.Type
    object IndexedTextDocumentsCount extends Subtype[Int]
    type IndexedTextDocumentsCount =
      zio.aws.kendra.model.primitives.IndexedTextDocumentsCount.Type
    type Integer = Int
    object Issuer extends Subtype[String]
    type Issuer = zio.aws.kendra.model.primitives.Issuer.Type
    object KmsKeyId extends Subtype[String]
    type KmsKeyId = zio.aws.kendra.model.primitives.KmsKeyId.Type
    object LambdaArn extends Subtype[String]
    type LambdaArn = zio.aws.kendra.model.primitives.LambdaArn.Type
    object LanguageCode extends Subtype[String]
    type LanguageCode = zio.aws.kendra.model.primitives.LanguageCode.Type
    object LookBackPeriod extends Subtype[Int]
    type LookBackPeriod = zio.aws.kendra.model.primitives.LookBackPeriod.Type
    object MaxContentSizePerPageInMegaBytes extends Subtype[Float]
    type MaxContentSizePerPageInMegaBytes =
      zio.aws.kendra.model.primitives.MaxContentSizePerPageInMegaBytes.Type
    object MaxLinksPerPage extends Subtype[Int]
    type MaxLinksPerPage = zio.aws.kendra.model.primitives.MaxLinksPerPage.Type
    object MaxResultsIntegerForListDataSourceSyncJobsRequest
        extends Subtype[Int]
    type MaxResultsIntegerForListDataSourceSyncJobsRequest =
      zio.aws.kendra.model.primitives.MaxResultsIntegerForListDataSourceSyncJobsRequest.Type
    object MaxResultsIntegerForListDataSourcesRequest extends Subtype[Int]
    type MaxResultsIntegerForListDataSourcesRequest =
      zio.aws.kendra.model.primitives.MaxResultsIntegerForListDataSourcesRequest.Type
    object MaxResultsIntegerForListEntityPersonasRequest extends Subtype[Int]
    type MaxResultsIntegerForListEntityPersonasRequest =
      zio.aws.kendra.model.primitives.MaxResultsIntegerForListEntityPersonasRequest.Type
    object MaxResultsIntegerForListExperiencesRequest extends Subtype[Int]
    type MaxResultsIntegerForListExperiencesRequest =
      zio.aws.kendra.model.primitives.MaxResultsIntegerForListExperiencesRequest.Type
    object MaxResultsIntegerForListFaqsRequest extends Subtype[Int]
    type MaxResultsIntegerForListFaqsRequest =
      zio.aws.kendra.model.primitives.MaxResultsIntegerForListFaqsRequest.Type
    object MaxResultsIntegerForListIndicesRequest extends Subtype[Int]
    type MaxResultsIntegerForListIndicesRequest =
      zio.aws.kendra.model.primitives.MaxResultsIntegerForListIndicesRequest.Type
    object MaxResultsIntegerForListPrincipalsRequest extends Subtype[Int]
    type MaxResultsIntegerForListPrincipalsRequest =
      zio.aws.kendra.model.primitives.MaxResultsIntegerForListPrincipalsRequest.Type
    object MaxResultsIntegerForListQuerySuggestionsBlockLists
        extends Subtype[Int]
    type MaxResultsIntegerForListQuerySuggestionsBlockLists =
      zio.aws.kendra.model.primitives.MaxResultsIntegerForListQuerySuggestionsBlockLists.Type
    object MaxResultsIntegerForListThesauriRequest extends Subtype[Int]
    type MaxResultsIntegerForListThesauriRequest =
      zio.aws.kendra.model.primitives.MaxResultsIntegerForListThesauriRequest.Type
    object MaxUrlsPerMinuteCrawlRate extends Subtype[Int]
    type MaxUrlsPerMinuteCrawlRate =
      zio.aws.kendra.model.primitives.MaxUrlsPerMinuteCrawlRate.Type
    object MetricValue extends Subtype[String]
    type MetricValue = zio.aws.kendra.model.primitives.MetricValue.Type
    object MimeType extends Subtype[String]
    type MimeType = zio.aws.kendra.model.primitives.MimeType.Type
    object MinimumNumberOfQueryingUsers extends Subtype[Int]
    type MinimumNumberOfQueryingUsers =
      zio.aws.kendra.model.primitives.MinimumNumberOfQueryingUsers.Type
    object MinimumQueryCount extends Subtype[Int]
    type MinimumQueryCount =
      zio.aws.kendra.model.primitives.MinimumQueryCount.Type
    object NameType extends Subtype[String]
    type NameType = zio.aws.kendra.model.primitives.NameType.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.kendra.model.primitives.NextToken.Type
    object ObjectBoolean extends Subtype[Boolean]
    type ObjectBoolean = zio.aws.kendra.model.primitives.ObjectBoolean.Type
    object OneDriveUser extends Subtype[String]
    type OneDriveUser = zio.aws.kendra.model.primitives.OneDriveUser.Type
    object OrganizationId extends Subtype[String]
    type OrganizationId = zio.aws.kendra.model.primitives.OrganizationId.Type
    object Port extends Subtype[Int]
    type Port = zio.aws.kendra.model.primitives.Port.Type
    object PrincipalName extends Subtype[String]
    type PrincipalName = zio.aws.kendra.model.primitives.PrincipalName.Type
    object PrincipalOrderingId extends Subtype[Long]
    type PrincipalOrderingId =
      zio.aws.kendra.model.primitives.PrincipalOrderingId.Type
    object QueryCapacityUnit extends Subtype[Int]
    type QueryCapacityUnit =
      zio.aws.kendra.model.primitives.QueryCapacityUnit.Type
    object QueryId extends Subtype[String]
    type QueryId = zio.aws.kendra.model.primitives.QueryId.Type
    object QuerySuggestionsBlockListId extends Subtype[String]
    type QuerySuggestionsBlockListId =
      zio.aws.kendra.model.primitives.QuerySuggestionsBlockListId.Type
    object QuerySuggestionsBlockListName extends Subtype[String]
    type QuerySuggestionsBlockListName =
      zio.aws.kendra.model.primitives.QuerySuggestionsBlockListName.Type
    object QuerySuggestionsId extends Subtype[String]
    type QuerySuggestionsId =
      zio.aws.kendra.model.primitives.QuerySuggestionsId.Type
    object QueryText extends Subtype[String]
    type QueryText = zio.aws.kendra.model.primitives.QueryText.Type
    object ResultId extends Subtype[String]
    type ResultId = zio.aws.kendra.model.primitives.ResultId.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.kendra.model.primitives.RoleArn.Type
    object S3BucketName extends Subtype[String]
    type S3BucketName = zio.aws.kendra.model.primitives.S3BucketName.Type
    object S3ObjectKey extends Subtype[String]
    type S3ObjectKey = zio.aws.kendra.model.primitives.S3ObjectKey.Type
    object SalesforceCustomKnowledgeArticleTypeName extends Subtype[String]
    type SalesforceCustomKnowledgeArticleTypeName =
      zio.aws.kendra.model.primitives.SalesforceCustomKnowledgeArticleTypeName.Type
    object ScanSchedule extends Subtype[String]
    type ScanSchedule = zio.aws.kendra.model.primitives.ScanSchedule.Type
    object SecretArn extends Subtype[String]
    type SecretArn = zio.aws.kendra.model.primitives.SecretArn.Type
    object SeedUrl extends Subtype[String]
    type SeedUrl = zio.aws.kendra.model.primitives.SeedUrl.Type
    object ServiceNowHostUrl extends Subtype[String]
    type ServiceNowHostUrl =
      zio.aws.kendra.model.primitives.ServiceNowHostUrl.Type
    object ServiceNowKnowledgeArticleFilterQuery extends Subtype[String]
    type ServiceNowKnowledgeArticleFilterQuery =
      zio.aws.kendra.model.primitives.ServiceNowKnowledgeArticleFilterQuery.Type
    object SharedDriveId extends Subtype[String]
    type SharedDriveId = zio.aws.kendra.model.primitives.SharedDriveId.Type
    object SinceCrawlDate extends Subtype[String]
    type SinceCrawlDate = zio.aws.kendra.model.primitives.SinceCrawlDate.Type
    object SiteMap extends Subtype[String]
    type SiteMap = zio.aws.kendra.model.primitives.SiteMap.Type
    object StorageCapacityUnit extends Subtype[Int]
    type StorageCapacityUnit =
      zio.aws.kendra.model.primitives.StorageCapacityUnit.Type
    object SubnetId extends Subtype[String]
    type SubnetId = zio.aws.kendra.model.primitives.SubnetId.Type
    object SuggestedQueryText extends Subtype[String]
    type SuggestedQueryText =
      zio.aws.kendra.model.primitives.SuggestedQueryText.Type
    object SuggestionQueryText extends Subtype[String]
    type SuggestionQueryText =
      zio.aws.kendra.model.primitives.SuggestionQueryText.Type
    object TableName extends Subtype[String]
    type TableName = zio.aws.kendra.model.primitives.TableName.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.kendra.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.kendra.model.primitives.TagValue.Type
    object TeamId extends Subtype[String]
    type TeamId = zio.aws.kendra.model.primitives.TeamId.Type
    object TenantDomain extends Subtype[String]
    type TenantDomain = zio.aws.kendra.model.primitives.TenantDomain.Type
    object ThesaurusId extends Subtype[String]
    type ThesaurusId = zio.aws.kendra.model.primitives.ThesaurusId.Type
    object ThesaurusName extends Subtype[String]
    type ThesaurusName = zio.aws.kendra.model.primitives.ThesaurusName.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.kendra.model.primitives.Timestamp.Type
    object Title extends Subtype[String]
    type Title = zio.aws.kendra.model.primitives.Title.Type
    object Token extends Subtype[String]
    type Token = zio.aws.kendra.model.primitives.Token.Type
    object Url extends Subtype[String]
    type Url = zio.aws.kendra.model.primitives.Url.Type
    object UserAccount extends Subtype[String]
    type UserAccount = zio.aws.kendra.model.primitives.UserAccount.Type
    object UserId extends Subtype[String]
    type UserId = zio.aws.kendra.model.primitives.UserId.Type
    object UserNameAttributeField extends Subtype[String]
    type UserNameAttributeField =
      zio.aws.kendra.model.primitives.UserNameAttributeField.Type
    object ValueImportanceMapKey extends Subtype[String]
    type ValueImportanceMapKey =
      zio.aws.kendra.model.primitives.ValueImportanceMapKey.Type
    object VisitorId extends Subtype[String]
    type VisitorId = zio.aws.kendra.model.primitives.VisitorId.Type
    object VpcSecurityGroupId extends Subtype[String]
    type VpcSecurityGroupId =
      zio.aws.kendra.model.primitives.VpcSecurityGroupId.Type
    object WarningMessage extends Subtype[String]
    type WarningMessage = zio.aws.kendra.model.primitives.WarningMessage.Type
  }
  type AdditionalResultAttributeList =
    List[zio.aws.kendra.model.AdditionalResultAttribute]
  type AssociateEntitiesToExperienceFailedEntityList =
    List[zio.aws.kendra.model.FailedEntity]
  type AssociateEntityList = List[zio.aws.kendra.model.EntityConfiguration]
  type AttributeFilterList = List[zio.aws.kendra.model.AttributeFilter]
  type BasicAuthenticationConfigurationList =
    List[zio.aws.kendra.model.BasicAuthenticationConfiguration]
  type BatchDeleteDocumentResponseFailedDocuments =
    List[zio.aws.kendra.model.BatchDeleteDocumentResponseFailedDocument]
  type BatchGetDocumentStatusResponseErrors =
    List[zio.aws.kendra.model.BatchGetDocumentStatusResponseError]
  type BatchPutDocumentResponseFailedDocuments =
    List[zio.aws.kendra.model.BatchPutDocumentResponseFailedDocument]
  type ChangeDetectingColumns = List[ColumnName]
  type ClickFeedbackList = List[zio.aws.kendra.model.ClickFeedback]
  type ConfluenceAttachmentFieldMappingsList =
    List[zio.aws.kendra.model.ConfluenceAttachmentToIndexFieldMapping]
  type ConfluenceBlogFieldMappingsList =
    List[zio.aws.kendra.model.ConfluenceBlogToIndexFieldMapping]
  type ConfluencePageFieldMappingsList =
    List[zio.aws.kendra.model.ConfluencePageToIndexFieldMapping]
  type ConfluenceSpaceFieldMappingsList =
    List[zio.aws.kendra.model.ConfluenceSpaceToIndexFieldMapping]
  type ConfluenceSpaceList = List[ConfluenceSpaceIdentifier]
  type CorrectionList = List[zio.aws.kendra.model.Correction]
  type DataSourceGroups = List[zio.aws.kendra.model.DataSourceGroup]
  type DataSourceIdList = List[DataSourceId]
  type DataSourceInclusionsExclusionsStrings =
    List[DataSourceInclusionsExclusionsStringsMember]
  type DataSourceSummaryList = List[zio.aws.kendra.model.DataSourceSummary]
  type DataSourceSyncJobHistoryList =
    List[zio.aws.kendra.model.DataSourceSyncJob]
  type DataSourceToIndexFieldMappingList =
    List[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
  type DisassociateEntityList = List[zio.aws.kendra.model.EntityConfiguration]
  type DocumentAttributeKeyList = List[DocumentAttributeKey]
  type DocumentAttributeList = List[zio.aws.kendra.model.DocumentAttribute]
  type DocumentAttributeStringListValue = List[String]
  type DocumentAttributeValueCountPairList =
    List[zio.aws.kendra.model.DocumentAttributeValueCountPair]
  type DocumentIdList = List[DocumentId]
  type DocumentInfoList = List[zio.aws.kendra.model.DocumentInfo]
  type DocumentList = List[zio.aws.kendra.model.Document]
  type DocumentMetadataConfigurationList =
    List[zio.aws.kendra.model.DocumentMetadataConfiguration]
  type DocumentRelevanceOverrideConfigurationList =
    List[zio.aws.kendra.model.DocumentRelevanceConfiguration]
  type DocumentStatusList = List[zio.aws.kendra.model.Status]
  type EntityIdsList = List[EntityId]
  type EntityPersonaConfigurationList =
    List[zio.aws.kendra.model.EntityPersonaConfiguration]
  type ExcludeMimeTypesList = List[MimeType]
  type ExcludeSharedDrivesList = List[SharedDriveId]
  type ExcludeUserAccountsList = List[UserAccount]
  type ExperienceEndpoints = List[zio.aws.kendra.model.ExperienceEndpoint]
  type ExperienceEntitiesSummaryList =
    List[zio.aws.kendra.model.ExperienceEntitiesSummary]
  type ExperiencesSummaryList = List[zio.aws.kendra.model.ExperiencesSummary]
  type FacetList = List[zio.aws.kendra.model.Facet]
  type FacetResultList = List[zio.aws.kendra.model.FacetResult]
  type FailedEntityList = List[zio.aws.kendra.model.FailedEntity]
  type FaqIdsList = List[FaqId]
  type FaqSummaryItems = List[zio.aws.kendra.model.FaqSummary]
  type GroupOrderingIdSummaries =
    List[zio.aws.kendra.model.GroupOrderingIdSummary]
  type Groups = List[PrincipalName]
  type HierarchicalPrincipalList =
    List[zio.aws.kendra.model.HierarchicalPrincipal]
  type HighlightList = List[zio.aws.kendra.model.Highlight]
  type IndexConfigurationSummaryList =
    List[zio.aws.kendra.model.IndexConfigurationSummary]
  type InlineCustomDocumentEnrichmentConfigurationList =
    List[zio.aws.kendra.model.InlineCustomDocumentEnrichmentConfiguration]
  type ListOfGroupSummaries = List[zio.aws.kendra.model.GroupSummary]
  type MemberGroups = List[zio.aws.kendra.model.MemberGroup]
  type MemberUsers = List[zio.aws.kendra.model.MemberUser]
  type OneDriveUserList = List[OneDriveUser]
  type PersonasSummaryList = List[zio.aws.kendra.model.PersonasSummary]
  type PrincipalList = List[zio.aws.kendra.model.Principal]
  type PrivateChannelFilter = List[String]
  type PublicChannelFilter = List[String]
  type QueryResultItemList = List[zio.aws.kendra.model.QueryResultItem]
  type QuerySuggestionsBlockListSummaryItems =
    List[zio.aws.kendra.model.QuerySuggestionsBlockListSummary]
  type RelevanceFeedbackList = List[zio.aws.kendra.model.RelevanceFeedback]
  type SalesforceChatterFeedIncludeFilterTypes =
    List[zio.aws.kendra.model.SalesforceChatterFeedIncludeFilterType]
  type SalesforceCustomKnowledgeArticleTypeConfigurationList =
    List[zio.aws.kendra.model.SalesforceCustomKnowledgeArticleTypeConfiguration]
  type SalesforceKnowledgeArticleStateList =
    List[zio.aws.kendra.model.SalesforceKnowledgeArticleState]
  type SalesforceStandardObjectConfigurationList =
    List[zio.aws.kendra.model.SalesforceStandardObjectConfiguration]
  type SecurityGroupIdList = List[VpcSecurityGroupId]
  type SeedUrlList = List[SeedUrl]
  type SharePointUrlList = List[Url]
  type SiteMapsList = List[SiteMap]
  type SlackEntityList = List[zio.aws.kendra.model.SlackEntity]
  type SnapshotsDataHeaderFields = List[String]
  type SnapshotsDataRecord = List[String]
  type SnapshotsDataRecords = List[Iterable[String]]
  type SpellCorrectedQueryList = List[zio.aws.kendra.model.SpellCorrectedQuery]
  type SubnetIdList = List[SubnetId]
  type SuggestionHighlightList = List[zio.aws.kendra.model.SuggestionHighlight]
  type SuggestionList = List[zio.aws.kendra.model.Suggestion]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.kendra.model.Tag]
  type ThesaurusSummaryItems = List[zio.aws.kendra.model.ThesaurusSummary]
  type UserTokenConfigurationList =
    List[zio.aws.kendra.model.UserTokenConfiguration]
  type ValueImportanceMap = Map[ValueImportanceMapKey, Importance]
  type WarningList = List[zio.aws.kendra.model.Warning]
}
