package zio.aws.kendra
import zio.aws.kendra.model.PersonasSummary.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.kendra.KendraAsyncClient
import zio.aws.kendra.model.{
  StopDataSourceSyncJobRequest,
  UpdateQuerySuggestionsBlockListRequest,
  DescribeDataSourceRequest,
  UpdateAccessControlConfigurationRequest,
  DescribeFaqRequest,
  DescribeThesaurusRequest,
  ListIndicesRequest,
  UpdateDataSourceRequest,
  DisassociatePersonasFromEntitiesRequest,
  GetSnapshotsRequest,
  ListEntityPersonasRequest,
  DescribeAccessControlConfigurationRequest,
  UpdateExperienceRequest,
  BatchGetDocumentStatusRequest,
  CreateIndexRequest,
  DescribeQuerySuggestionsBlockListRequest,
  GetQuerySuggestionsRequest,
  AssociateEntitiesToExperienceRequest,
  ListTagsForResourceRequest,
  CreateQuerySuggestionsBlockListRequest,
  DescribeQuerySuggestionsConfigRequest,
  ListFaqsRequest,
  CreateDataSourceRequest,
  BatchPutDocumentRequest,
  CreateExperienceRequest,
  DeletePrincipalMappingRequest,
  ListGroupsOlderThanOrderingIdRequest,
  ClearQuerySuggestionsRequest,
  PutPrincipalMappingRequest,
  CreateThesaurusRequest,
  CreateFaqRequest,
  ListThesauriRequest,
  DescribePrincipalMappingRequest,
  DeleteExperienceRequest,
  DeleteAccessControlConfigurationRequest,
  DeleteQuerySuggestionsBlockListRequest,
  ListExperienceEntitiesRequest,
  ListDataSourcesRequest,
  UpdateIndexRequest,
  UpdateThesaurusRequest,
  DeleteDataSourceRequest,
  QueryRequest,
  DeleteThesaurusRequest,
  ListQuerySuggestionsBlockListsRequest,
  UntagResourceRequest,
  DeleteFaqRequest,
  SubmitFeedbackRequest,
  DescribeExperienceRequest,
  StartDataSourceSyncJobRequest,
  ListExperiencesRequest,
  DeleteIndexRequest,
  ListAccessControlConfigurationsRequest,
  UpdateQuerySuggestionsConfigRequest,
  DisassociateEntitiesFromExperienceRequest,
  AssociatePersonasToEntitiesRequest,
  ListDataSourceSyncJobsRequest,
  BatchDeleteDocumentRequest,
  TagResourceRequest,
  DescribeIndexRequest,
  CreateAccessControlConfigurationRequest
}
import zio.stream.ZStream
object KendraMock extends Mock[Kendra] {
  object BatchGetDocumentStatus
      extends Effect[
        BatchGetDocumentStatusRequest,
        AwsError,
        zio.aws.kendra.model.BatchGetDocumentStatusResponse.ReadOnly
      ]
  object ListQuerySuggestionsBlockLists
      extends Stream[
        ListQuerySuggestionsBlockListsRequest,
        AwsError,
        zio.aws.kendra.model.QuerySuggestionsBlockListSummary.ReadOnly
      ]
  object ListQuerySuggestionsBlockListsPaginated
      extends Effect[
        ListQuerySuggestionsBlockListsRequest,
        AwsError,
        zio.aws.kendra.model.ListQuerySuggestionsBlockListsResponse.ReadOnly
      ]
  object UpdateIndex extends Effect[UpdateIndexRequest, AwsError, Unit]
  object DescribeQuerySuggestionsBlockList
      extends Effect[
        DescribeQuerySuggestionsBlockListRequest,
        AwsError,
        zio.aws.kendra.model.DescribeQuerySuggestionsBlockListResponse.ReadOnly
      ]
  object CreateFaq
      extends Effect[
        CreateFaqRequest,
        AwsError,
        zio.aws.kendra.model.CreateFaqResponse.ReadOnly
      ]
  object ListIndices
      extends Stream[
        ListIndicesRequest,
        AwsError,
        zio.aws.kendra.model.IndexConfigurationSummary.ReadOnly
      ]
  object ListIndicesPaginated
      extends Effect[
        ListIndicesRequest,
        AwsError,
        zio.aws.kendra.model.ListIndicesResponse.ReadOnly
      ]
  object CreateExperience
      extends Effect[
        CreateExperienceRequest,
        AwsError,
        zio.aws.kendra.model.CreateExperienceResponse.ReadOnly
      ]
  object DescribeQuerySuggestionsConfig
      extends Effect[
        DescribeQuerySuggestionsConfigRequest,
        AwsError,
        zio.aws.kendra.model.DescribeQuerySuggestionsConfigResponse.ReadOnly
      ]
  object DescribeDataSource
      extends Effect[
        DescribeDataSourceRequest,
        AwsError,
        zio.aws.kendra.model.DescribeDataSourceResponse.ReadOnly
      ]
  object CreateQuerySuggestionsBlockList
      extends Effect[
        CreateQuerySuggestionsBlockListRequest,
        AwsError,
        zio.aws.kendra.model.CreateQuerySuggestionsBlockListResponse.ReadOnly
      ]
  object UpdateThesaurus extends Effect[UpdateThesaurusRequest, AwsError, Unit]
  object DescribePrincipalMapping
      extends Effect[
        DescribePrincipalMappingRequest,
        AwsError,
        zio.aws.kendra.model.DescribePrincipalMappingResponse.ReadOnly
      ]
  object AssociatePersonasToEntities
      extends Effect[
        AssociatePersonasToEntitiesRequest,
        AwsError,
        zio.aws.kendra.model.AssociatePersonasToEntitiesResponse.ReadOnly
      ]
  object UpdateQuerySuggestionsBlockList
      extends Effect[UpdateQuerySuggestionsBlockListRequest, AwsError, Unit]
  object AssociateEntitiesToExperience
      extends Effect[
        AssociateEntitiesToExperienceRequest,
        AwsError,
        zio.aws.kendra.model.AssociateEntitiesToExperienceResponse.ReadOnly
      ]
  object DescribeThesaurus
      extends Effect[
        DescribeThesaurusRequest,
        AwsError,
        zio.aws.kendra.model.DescribeThesaurusResponse.ReadOnly
      ]
  object DisassociateEntitiesFromExperience
      extends Effect[
        DisassociateEntitiesFromExperienceRequest,
        AwsError,
        zio.aws.kendra.model.DisassociateEntitiesFromExperienceResponse.ReadOnly
      ]
  object StopDataSourceSyncJob
      extends Effect[StopDataSourceSyncJobRequest, AwsError, Unit]
  object ListEntityPersonas
      extends Stream[ListEntityPersonasRequest, AwsError, ReadOnly]
  object ListEntityPersonasPaginated
      extends Effect[
        ListEntityPersonasRequest,
        AwsError,
        zio.aws.kendra.model.ListEntityPersonasResponse.ReadOnly
      ]
  object ClearQuerySuggestions
      extends Effect[ClearQuerySuggestionsRequest, AwsError, Unit]
  object DescribeIndex
      extends Effect[
        DescribeIndexRequest,
        AwsError,
        zio.aws.kendra.model.DescribeIndexResponse.ReadOnly
      ]
  object CreateDataSource
      extends Effect[
        CreateDataSourceRequest,
        AwsError,
        zio.aws.kendra.model.CreateDataSourceResponse.ReadOnly
      ]
  object DeletePrincipalMapping
      extends Effect[DeletePrincipalMappingRequest, AwsError, Unit]
  object DescribeFaq
      extends Effect[
        DescribeFaqRequest,
        AwsError,
        zio.aws.kendra.model.DescribeFaqResponse.ReadOnly
      ]
  object GetSnapshots
      extends Effect[
        GetSnapshotsRequest,
        AwsError,
        zio.aws.kendra.model.GetSnapshotsResponse.ReadOnly
      ]
  object CreateThesaurus
      extends Effect[
        CreateThesaurusRequest,
        AwsError,
        zio.aws.kendra.model.CreateThesaurusResponse.ReadOnly
      ]
  object UpdateExperience
      extends Effect[UpdateExperienceRequest, AwsError, Unit]
  object Query
      extends Effect[
        QueryRequest,
        AwsError,
        zio.aws.kendra.model.QueryResponse.ReadOnly
      ]
  object UpdateAccessControlConfiguration
      extends Effect[
        UpdateAccessControlConfigurationRequest,
        AwsError,
        zio.aws.kendra.model.UpdateAccessControlConfigurationResponse.ReadOnly
      ]
  object ListDataSourceSyncJobs
      extends Stream[
        ListDataSourceSyncJobsRequest,
        AwsError,
        zio.aws.kendra.model.DataSourceSyncJob.ReadOnly
      ]
  object ListDataSourceSyncJobsPaginated
      extends Effect[
        ListDataSourceSyncJobsRequest,
        AwsError,
        zio.aws.kendra.model.ListDataSourceSyncJobsResponse.ReadOnly
      ]
  object ListDataSources
      extends Stream[
        ListDataSourcesRequest,
        AwsError,
        zio.aws.kendra.model.DataSourceSummary.ReadOnly
      ]
  object ListDataSourcesPaginated
      extends Effect[
        ListDataSourcesRequest,
        AwsError,
        zio.aws.kendra.model.ListDataSourcesResponse.ReadOnly
      ]
  object DisassociatePersonasFromEntities
      extends Effect[
        DisassociatePersonasFromEntitiesRequest,
        AwsError,
        zio.aws.kendra.model.DisassociatePersonasFromEntitiesResponse.ReadOnly
      ]
  object SubmitFeedback extends Effect[SubmitFeedbackRequest, AwsError, Unit]
  object ListAccessControlConfigurations
      extends Stream[
        ListAccessControlConfigurationsRequest,
        AwsError,
        zio.aws.kendra.model.AccessControlConfigurationSummary.ReadOnly
      ]
  object ListAccessControlConfigurationsPaginated
      extends Effect[
        ListAccessControlConfigurationsRequest,
        AwsError,
        zio.aws.kendra.model.ListAccessControlConfigurationsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.kendra.model.UntagResourceResponse.ReadOnly
      ]
  object UpdateDataSource
      extends Effect[UpdateDataSourceRequest, AwsError, Unit]
  object ListExperiences
      extends Stream[
        ListExperiencesRequest,
        AwsError,
        zio.aws.kendra.model.ExperiencesSummary.ReadOnly
      ]
  object ListExperiencesPaginated
      extends Effect[
        ListExperiencesRequest,
        AwsError,
        zio.aws.kendra.model.ListExperiencesResponse.ReadOnly
      ]
  object BatchDeleteDocument
      extends Effect[
        BatchDeleteDocumentRequest,
        AwsError,
        zio.aws.kendra.model.BatchDeleteDocumentResponse.ReadOnly
      ]
  object DeleteDataSource
      extends Effect[DeleteDataSourceRequest, AwsError, Unit]
  object UpdateQuerySuggestionsConfig
      extends Effect[UpdateQuerySuggestionsConfigRequest, AwsError, Unit]
  object BatchPutDocument
      extends Effect[
        BatchPutDocumentRequest,
        AwsError,
        zio.aws.kendra.model.BatchPutDocumentResponse.ReadOnly
      ]
  object DeleteFaq extends Effect[DeleteFaqRequest, AwsError, Unit]
  object GetQuerySuggestions
      extends Effect[
        GetQuerySuggestionsRequest,
        AwsError,
        zio.aws.kendra.model.GetQuerySuggestionsResponse.ReadOnly
      ]
  object DeleteExperience
      extends Effect[
        DeleteExperienceRequest,
        AwsError,
        zio.aws.kendra.model.DeleteExperienceResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.kendra.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DeleteThesaurus extends Effect[DeleteThesaurusRequest, AwsError, Unit]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.kendra.model.TagResourceResponse.ReadOnly
      ]
  object DeleteIndex extends Effect[DeleteIndexRequest, AwsError, Unit]
  object DescribeAccessControlConfiguration
      extends Effect[
        DescribeAccessControlConfigurationRequest,
        AwsError,
        zio.aws.kendra.model.DescribeAccessControlConfigurationResponse.ReadOnly
      ]
  object DescribeExperience
      extends Effect[
        DescribeExperienceRequest,
        AwsError,
        zio.aws.kendra.model.DescribeExperienceResponse.ReadOnly
      ]
  object ListThesauri
      extends Stream[
        ListThesauriRequest,
        AwsError,
        zio.aws.kendra.model.ThesaurusSummary.ReadOnly
      ]
  object ListThesauriPaginated
      extends Effect[
        ListThesauriRequest,
        AwsError,
        zio.aws.kendra.model.ListThesauriResponse.ReadOnly
      ]
  object PutPrincipalMapping
      extends Effect[PutPrincipalMappingRequest, AwsError, Unit]
  object ListExperienceEntities
      extends Stream[
        ListExperienceEntitiesRequest,
        AwsError,
        zio.aws.kendra.model.ExperienceEntitiesSummary.ReadOnly
      ]
  object ListExperienceEntitiesPaginated
      extends Effect[
        ListExperienceEntitiesRequest,
        AwsError,
        zio.aws.kendra.model.ListExperienceEntitiesResponse.ReadOnly
      ]
  object DeleteQuerySuggestionsBlockList
      extends Effect[DeleteQuerySuggestionsBlockListRequest, AwsError, Unit]
  object ListFaqs
      extends Stream[
        ListFaqsRequest,
        AwsError,
        zio.aws.kendra.model.FaqSummary.ReadOnly
      ]
  object ListFaqsPaginated
      extends Effect[
        ListFaqsRequest,
        AwsError,
        zio.aws.kendra.model.ListFaqsResponse.ReadOnly
      ]
  object CreateAccessControlConfiguration
      extends Effect[
        CreateAccessControlConfigurationRequest,
        AwsError,
        zio.aws.kendra.model.CreateAccessControlConfigurationResponse.ReadOnly
      ]
  object CreateIndex
      extends Effect[
        CreateIndexRequest,
        AwsError,
        zio.aws.kendra.model.CreateIndexResponse.ReadOnly
      ]
  object DeleteAccessControlConfiguration
      extends Effect[
        DeleteAccessControlConfigurationRequest,
        AwsError,
        zio.aws.kendra.model.DeleteAccessControlConfigurationResponse.ReadOnly
      ]
  object StartDataSourceSyncJob
      extends Effect[
        StartDataSourceSyncJobRequest,
        AwsError,
        zio.aws.kendra.model.StartDataSourceSyncJobResponse.ReadOnly
      ]
  object ListGroupsOlderThanOrderingId
      extends Stream[
        ListGroupsOlderThanOrderingIdRequest,
        AwsError,
        zio.aws.kendra.model.GroupSummary.ReadOnly
      ]
  object ListGroupsOlderThanOrderingIdPaginated
      extends Effect[
        ListGroupsOlderThanOrderingIdRequest,
        AwsError,
        zio.aws.kendra.model.ListGroupsOlderThanOrderingIdResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Kendra] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Kendra] { rts =>
        zio.ZIO.succeed {
          new Kendra {
            val api: KendraAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Kendra = this
            def batchGetDocumentStatus(
                request: BatchGetDocumentStatusRequest
            ): IO[
              AwsError,
              zio.aws.kendra.model.BatchGetDocumentStatusResponse.ReadOnly
            ] = proxy(BatchGetDocumentStatus, request)
            def listQuerySuggestionsBlockLists(
                request: ListQuerySuggestionsBlockListsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.kendra.model.QuerySuggestionsBlockListSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListQuerySuggestionsBlockLists, request)
                }
                .getOrThrowFiberFailure()
            }
            def listQuerySuggestionsBlockListsPaginated(
                request: ListQuerySuggestionsBlockListsRequest
            ): IO[
              AwsError,
              zio.aws.kendra.model.ListQuerySuggestionsBlockListsResponse.ReadOnly
            ] = proxy(ListQuerySuggestionsBlockListsPaginated, request)
            def updateIndex(request: UpdateIndexRequest): IO[AwsError, Unit] =
              proxy(UpdateIndex, request)
            def describeQuerySuggestionsBlockList(
                request: DescribeQuerySuggestionsBlockListRequest
            ): IO[
              AwsError,
              zio.aws.kendra.model.DescribeQuerySuggestionsBlockListResponse.ReadOnly
            ] = proxy(DescribeQuerySuggestionsBlockList, request)
            def createFaq(
                request: CreateFaqRequest
            ): IO[AwsError, zio.aws.kendra.model.CreateFaqResponse.ReadOnly] =
              proxy(CreateFaq, request)
            def listIndices(request: ListIndicesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.kendra.model.IndexConfigurationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListIndices, request)
                }
                .getOrThrowFiberFailure()
            }
            def listIndicesPaginated(
                request: ListIndicesRequest
            ): IO[AwsError, zio.aws.kendra.model.ListIndicesResponse.ReadOnly] =
              proxy(ListIndicesPaginated, request)
            def createExperience(request: CreateExperienceRequest): IO[
              AwsError,
              zio.aws.kendra.model.CreateExperienceResponse.ReadOnly
            ] = proxy(CreateExperience, request)
            def describeQuerySuggestionsConfig(
                request: DescribeQuerySuggestionsConfigRequest
            ): IO[
              AwsError,
              zio.aws.kendra.model.DescribeQuerySuggestionsConfigResponse.ReadOnly
            ] = proxy(DescribeQuerySuggestionsConfig, request)
            def describeDataSource(request: DescribeDataSourceRequest): IO[
              AwsError,
              zio.aws.kendra.model.DescribeDataSourceResponse.ReadOnly
            ] = proxy(DescribeDataSource, request)
            def createQuerySuggestionsBlockList(
                request: CreateQuerySuggestionsBlockListRequest
            ): IO[
              AwsError,
              zio.aws.kendra.model.CreateQuerySuggestionsBlockListResponse.ReadOnly
            ] = proxy(CreateQuerySuggestionsBlockList, request)
            def updateThesaurus(
                request: UpdateThesaurusRequest
            ): IO[AwsError, Unit] = proxy(UpdateThesaurus, request)
            def describePrincipalMapping(
                request: DescribePrincipalMappingRequest
            ): IO[
              AwsError,
              zio.aws.kendra.model.DescribePrincipalMappingResponse.ReadOnly
            ] = proxy(DescribePrincipalMapping, request)
            def associatePersonasToEntities(
                request: AssociatePersonasToEntitiesRequest
            ): IO[
              AwsError,
              zio.aws.kendra.model.AssociatePersonasToEntitiesResponse.ReadOnly
            ] = proxy(AssociatePersonasToEntities, request)
            def updateQuerySuggestionsBlockList(
                request: UpdateQuerySuggestionsBlockListRequest
            ): IO[AwsError, Unit] =
              proxy(UpdateQuerySuggestionsBlockList, request)
            def associateEntitiesToExperience(
                request: AssociateEntitiesToExperienceRequest
            ): IO[
              AwsError,
              zio.aws.kendra.model.AssociateEntitiesToExperienceResponse.ReadOnly
            ] = proxy(AssociateEntitiesToExperience, request)
            def describeThesaurus(request: DescribeThesaurusRequest): IO[
              AwsError,
              zio.aws.kendra.model.DescribeThesaurusResponse.ReadOnly
            ] = proxy(DescribeThesaurus, request)
            def disassociateEntitiesFromExperience(
                request: DisassociateEntitiesFromExperienceRequest
            ): IO[
              AwsError,
              zio.aws.kendra.model.DisassociateEntitiesFromExperienceResponse.ReadOnly
            ] = proxy(DisassociateEntitiesFromExperience, request)
            def stopDataSourceSyncJob(
                request: StopDataSourceSyncJobRequest
            ): IO[AwsError, Unit] = proxy(StopDataSourceSyncJob, request)
            def listEntityPersonas(
                request: ListEntityPersonasRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListEntityPersonas, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listEntityPersonasPaginated(
                request: ListEntityPersonasRequest
            ): IO[
              AwsError,
              zio.aws.kendra.model.ListEntityPersonasResponse.ReadOnly
            ] = proxy(ListEntityPersonasPaginated, request)
            def clearQuerySuggestions(
                request: ClearQuerySuggestionsRequest
            ): IO[AwsError, Unit] = proxy(ClearQuerySuggestions, request)
            def describeIndex(request: DescribeIndexRequest): IO[
              AwsError,
              zio.aws.kendra.model.DescribeIndexResponse.ReadOnly
            ] = proxy(DescribeIndex, request)
            def createDataSource(request: CreateDataSourceRequest): IO[
              AwsError,
              zio.aws.kendra.model.CreateDataSourceResponse.ReadOnly
            ] = proxy(CreateDataSource, request)
            def deletePrincipalMapping(
                request: DeletePrincipalMappingRequest
            ): IO[AwsError, Unit] = proxy(DeletePrincipalMapping, request)
            def describeFaq(
                request: DescribeFaqRequest
            ): IO[AwsError, zio.aws.kendra.model.DescribeFaqResponse.ReadOnly] =
              proxy(DescribeFaq, request)
            def getSnapshots(request: GetSnapshotsRequest): IO[
              AwsError,
              zio.aws.kendra.model.GetSnapshotsResponse.ReadOnly
            ] = proxy(GetSnapshots, request)
            def createThesaurus(request: CreateThesaurusRequest): IO[
              AwsError,
              zio.aws.kendra.model.CreateThesaurusResponse.ReadOnly
            ] = proxy(CreateThesaurus, request)
            def updateExperience(
                request: UpdateExperienceRequest
            ): IO[AwsError, Unit] = proxy(UpdateExperience, request)
            def query(
                request: QueryRequest
            ): IO[AwsError, zio.aws.kendra.model.QueryResponse.ReadOnly] =
              proxy(Query, request)
            def updateAccessControlConfiguration(
                request: UpdateAccessControlConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.kendra.model.UpdateAccessControlConfigurationResponse.ReadOnly
            ] = proxy(UpdateAccessControlConfiguration, request)
            def listDataSourceSyncJobs(
                request: ListDataSourceSyncJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.kendra.model.DataSourceSyncJob.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDataSourceSyncJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDataSourceSyncJobsPaginated(
                request: ListDataSourceSyncJobsRequest
            ): IO[
              AwsError,
              zio.aws.kendra.model.ListDataSourceSyncJobsResponse.ReadOnly
            ] = proxy(ListDataSourceSyncJobsPaginated, request)
            def listDataSources(request: ListDataSourcesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.kendra.model.DataSourceSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDataSources, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDataSourcesPaginated(request: ListDataSourcesRequest): IO[
              AwsError,
              zio.aws.kendra.model.ListDataSourcesResponse.ReadOnly
            ] = proxy(ListDataSourcesPaginated, request)
            def disassociatePersonasFromEntities(
                request: DisassociatePersonasFromEntitiesRequest
            ): IO[
              AwsError,
              zio.aws.kendra.model.DisassociatePersonasFromEntitiesResponse.ReadOnly
            ] = proxy(DisassociatePersonasFromEntities, request)
            def submitFeedback(
                request: SubmitFeedbackRequest
            ): IO[AwsError, Unit] = proxy(SubmitFeedback, request)
            def listAccessControlConfigurations(
                request: ListAccessControlConfigurationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.kendra.model.AccessControlConfigurationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAccessControlConfigurations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAccessControlConfigurationsPaginated(
                request: ListAccessControlConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.kendra.model.ListAccessControlConfigurationsResponse.ReadOnly
            ] = proxy(ListAccessControlConfigurationsPaginated, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.kendra.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def updateDataSource(
                request: UpdateDataSourceRequest
            ): IO[AwsError, Unit] = proxy(UpdateDataSource, request)
            def listExperiences(request: ListExperiencesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.kendra.model.ExperiencesSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListExperiences, request)
                }
                .getOrThrowFiberFailure()
            }
            def listExperiencesPaginated(request: ListExperiencesRequest): IO[
              AwsError,
              zio.aws.kendra.model.ListExperiencesResponse.ReadOnly
            ] = proxy(ListExperiencesPaginated, request)
            def batchDeleteDocument(request: BatchDeleteDocumentRequest): IO[
              AwsError,
              zio.aws.kendra.model.BatchDeleteDocumentResponse.ReadOnly
            ] = proxy(BatchDeleteDocument, request)
            def deleteDataSource(
                request: DeleteDataSourceRequest
            ): IO[AwsError, Unit] = proxy(DeleteDataSource, request)
            def updateQuerySuggestionsConfig(
                request: UpdateQuerySuggestionsConfigRequest
            ): IO[AwsError, Unit] = proxy(UpdateQuerySuggestionsConfig, request)
            def batchPutDocument(request: BatchPutDocumentRequest): IO[
              AwsError,
              zio.aws.kendra.model.BatchPutDocumentResponse.ReadOnly
            ] = proxy(BatchPutDocument, request)
            def deleteFaq(request: DeleteFaqRequest): IO[AwsError, Unit] =
              proxy(DeleteFaq, request)
            def getQuerySuggestions(request: GetQuerySuggestionsRequest): IO[
              AwsError,
              zio.aws.kendra.model.GetQuerySuggestionsResponse.ReadOnly
            ] = proxy(GetQuerySuggestions, request)
            def deleteExperience(request: DeleteExperienceRequest): IO[
              AwsError,
              zio.aws.kendra.model.DeleteExperienceResponse.ReadOnly
            ] = proxy(DeleteExperience, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.kendra.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def deleteThesaurus(
                request: DeleteThesaurusRequest
            ): IO[AwsError, Unit] = proxy(DeleteThesaurus, request)
            def tagResource(
                request: TagResourceRequest
            ): IO[AwsError, zio.aws.kendra.model.TagResourceResponse.ReadOnly] =
              proxy(TagResource, request)
            def deleteIndex(request: DeleteIndexRequest): IO[AwsError, Unit] =
              proxy(DeleteIndex, request)
            def describeAccessControlConfiguration(
                request: DescribeAccessControlConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.kendra.model.DescribeAccessControlConfigurationResponse.ReadOnly
            ] = proxy(DescribeAccessControlConfiguration, request)
            def describeExperience(request: DescribeExperienceRequest): IO[
              AwsError,
              zio.aws.kendra.model.DescribeExperienceResponse.ReadOnly
            ] = proxy(DescribeExperience, request)
            def listThesauri(request: ListThesauriRequest): ZStream[
              Any,
              AwsError,
              zio.aws.kendra.model.ThesaurusSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListThesauri, request)
                }
                .getOrThrowFiberFailure()
            }
            def listThesauriPaginated(request: ListThesauriRequest): IO[
              AwsError,
              zio.aws.kendra.model.ListThesauriResponse.ReadOnly
            ] = proxy(ListThesauriPaginated, request)
            def putPrincipalMapping(
                request: PutPrincipalMappingRequest
            ): IO[AwsError, Unit] = proxy(PutPrincipalMapping, request)
            def listExperienceEntities(
                request: ListExperienceEntitiesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.kendra.model.ExperienceEntitiesSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListExperienceEntities, request)
                }
                .getOrThrowFiberFailure()
            }
            def listExperienceEntitiesPaginated(
                request: ListExperienceEntitiesRequest
            ): IO[
              AwsError,
              zio.aws.kendra.model.ListExperienceEntitiesResponse.ReadOnly
            ] = proxy(ListExperienceEntitiesPaginated, request)
            def deleteQuerySuggestionsBlockList(
                request: DeleteQuerySuggestionsBlockListRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteQuerySuggestionsBlockList, request)
            def listFaqs(request: ListFaqsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.kendra.model.FaqSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFaqs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFaqsPaginated(
                request: ListFaqsRequest
            ): IO[AwsError, zio.aws.kendra.model.ListFaqsResponse.ReadOnly] =
              proxy(ListFaqsPaginated, request)
            def createAccessControlConfiguration(
                request: CreateAccessControlConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.kendra.model.CreateAccessControlConfigurationResponse.ReadOnly
            ] = proxy(CreateAccessControlConfiguration, request)
            def createIndex(
                request: CreateIndexRequest
            ): IO[AwsError, zio.aws.kendra.model.CreateIndexResponse.ReadOnly] =
              proxy(CreateIndex, request)
            def deleteAccessControlConfiguration(
                request: DeleteAccessControlConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.kendra.model.DeleteAccessControlConfigurationResponse.ReadOnly
            ] = proxy(DeleteAccessControlConfiguration, request)
            def startDataSourceSyncJob(
                request: StartDataSourceSyncJobRequest
            ): IO[
              AwsError,
              zio.aws.kendra.model.StartDataSourceSyncJobResponse.ReadOnly
            ] = proxy(StartDataSourceSyncJob, request)
            def listGroupsOlderThanOrderingId(
                request: ListGroupsOlderThanOrderingIdRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.kendra.model.GroupSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListGroupsOlderThanOrderingId, request)
                }
                .getOrThrowFiberFailure()
            }
            def listGroupsOlderThanOrderingIdPaginated(
                request: ListGroupsOlderThanOrderingIdRequest
            ): IO[
              AwsError,
              zio.aws.kendra.model.ListGroupsOlderThanOrderingIdResponse.ReadOnly
            ] = proxy(ListGroupsOlderThanOrderingIdPaginated, request)
          }
        }
      }
    }
  }
}
