package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait AlfrescoEntity {
  def unwrap: software.amazon.awssdk.services.kendra.model.AlfrescoEntity
}
object AlfrescoEntity {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.AlfrescoEntity
  ): zio.aws.kendra.model.AlfrescoEntity = value match {
    case software.amazon.awssdk.services.kendra.model.AlfrescoEntity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.AlfrescoEntity.WIKI =>
      val r = wiki
      r
    case software.amazon.awssdk.services.kendra.model.AlfrescoEntity.BLOG =>
      val r = blog
      r
    case software.amazon.awssdk.services.kendra.model.AlfrescoEntity.DOCUMENT_LIBRARY =>
      val r = documentLibrary
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.AlfrescoEntity {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.AlfrescoEntity =
      software.amazon.awssdk.services.kendra.model.AlfrescoEntity.UNKNOWN_TO_SDK_VERSION
  }
  case object wiki extends zio.aws.kendra.model.AlfrescoEntity {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.AlfrescoEntity =
      software.amazon.awssdk.services.kendra.model.AlfrescoEntity.WIKI
  }
  case object blog extends zio.aws.kendra.model.AlfrescoEntity {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.AlfrescoEntity =
      software.amazon.awssdk.services.kendra.model.AlfrescoEntity.BLOG
  }
  case object documentLibrary extends zio.aws.kendra.model.AlfrescoEntity {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.AlfrescoEntity =
      software.amazon.awssdk.services.kendra.model.AlfrescoEntity.DOCUMENT_LIBRARY
  }
}
