package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.IndexId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchGetDocumentStatusRequest(
    indexId: IndexId,
    documentInfoList: Iterable[zio.aws.kendra.model.DocumentInfo]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusRequest = {
    import BatchGetDocumentStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .documentInfoList(documentInfoList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.BatchGetDocumentStatusRequest.ReadOnly =
    zio.aws.kendra.model.BatchGetDocumentStatusRequest.wrap(buildAwsValue())
}
object BatchGetDocumentStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.BatchGetDocumentStatusRequest =
      zio.aws.kendra.model.BatchGetDocumentStatusRequest(
        indexId,
        documentInfoList.map { item =>
          item.asEditable
        }
      )
    def indexId: IndexId
    def documentInfoList: List[zio.aws.kendra.model.DocumentInfo.ReadOnly]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getDocumentInfoList
        : ZIO[Any, Nothing, List[zio.aws.kendra.model.DocumentInfo.ReadOnly]] =
      ZIO.succeed(documentInfoList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusRequest
  ) extends zio.aws.kendra.model.BatchGetDocumentStatusRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val documentInfoList
        : List[zio.aws.kendra.model.DocumentInfo.ReadOnly] = impl
      .documentInfoList()
      .asScala
      .map { item =>
        zio.aws.kendra.model.DocumentInfo.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusRequest
  ): zio.aws.kendra.model.BatchGetDocumentStatusRequest.ReadOnly = new Wrapper(
    impl
  )
}
