package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchGetDocumentStatusResponse(
    errors: Optional[
      Iterable[zio.aws.kendra.model.BatchGetDocumentStatusResponseError]
    ] = Optional.Absent,
    documentStatusList: Optional[Iterable[zio.aws.kendra.model.Status]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusResponse = {
    import BatchGetDocumentStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusResponse
      .builder()
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .optionallyWith(
        documentStatusList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentStatusList)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.BatchGetDocumentStatusResponse.ReadOnly =
    zio.aws.kendra.model.BatchGetDocumentStatusResponse.wrap(buildAwsValue())
}
object BatchGetDocumentStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.BatchGetDocumentStatusResponse =
      zio.aws.kendra.model.BatchGetDocumentStatusResponse(
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        documentStatusList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def errors: Optional[
      List[zio.aws.kendra.model.BatchGetDocumentStatusResponseError.ReadOnly]
    ]
    def documentStatusList: Optional[List[zio.aws.kendra.model.Status.ReadOnly]]
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.BatchGetDocumentStatusResponseError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
    def getDocumentStatusList
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.Status.ReadOnly]] =
      AwsError.unwrapOptionField("documentStatusList", documentStatusList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusResponse
  ) extends zio.aws.kendra.model.BatchGetDocumentStatusResponse.ReadOnly {
    override val errors: Optional[
      List[zio.aws.kendra.model.BatchGetDocumentStatusResponseError.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.BatchGetDocumentStatusResponseError.wrap(item)
        }.toList
      )
    override val documentStatusList
        : Optional[List[zio.aws.kendra.model.Status.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentStatusList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.Status.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusResponse
  ): zio.aws.kendra.model.BatchGetDocumentStatusResponse.ReadOnly = new Wrapper(
    impl
  )
}
