package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchPutDocumentResponse(
    failedDocuments: Optional[
      Iterable[zio.aws.kendra.model.BatchPutDocumentResponseFailedDocument]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.BatchPutDocumentResponse = {
    import BatchPutDocumentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.BatchPutDocumentResponse
      .builder()
      .optionallyWith(
        failedDocuments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedDocuments)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.BatchPutDocumentResponse.ReadOnly =
    zio.aws.kendra.model.BatchPutDocumentResponse.wrap(buildAwsValue())
}
object BatchPutDocumentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.BatchPutDocumentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.BatchPutDocumentResponse =
      zio.aws.kendra.model.BatchPutDocumentResponse(
        failedDocuments.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failedDocuments: Optional[
      List[zio.aws.kendra.model.BatchPutDocumentResponseFailedDocument.ReadOnly]
    ]
    def getFailedDocuments: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.BatchPutDocumentResponseFailedDocument.ReadOnly
    ]] = AwsError.unwrapOptionField("failedDocuments", failedDocuments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.BatchPutDocumentResponse
  ) extends zio.aws.kendra.model.BatchPutDocumentResponse.ReadOnly {
    override val failedDocuments: Optional[
      List[zio.aws.kendra.model.BatchPutDocumentResponseFailedDocument.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.failedDocuments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.BatchPutDocumentResponseFailedDocument.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.BatchPutDocumentResponse
  ): zio.aws.kendra.model.BatchPutDocumentResponse.ReadOnly = new Wrapper(impl)
}
