package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{Timestamp, ResultId}
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ClickFeedback(resultId: ResultId, clickTime: Timestamp) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ClickFeedback = {
    import ClickFeedback.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ClickFeedback
      .builder()
      .resultId(ResultId.unwrap(resultId): java.lang.String)
      .clickTime(Timestamp.unwrap(clickTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ClickFeedback.ReadOnly =
    zio.aws.kendra.model.ClickFeedback.wrap(buildAwsValue())
}
object ClickFeedback {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ClickFeedback
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ClickFeedback =
      zio.aws.kendra.model.ClickFeedback(resultId, clickTime)
    def resultId: ResultId
    def clickTime: Timestamp
    def getResultId: ZIO[Any, Nothing, ResultId] = ZIO.succeed(resultId)
    def getClickTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(clickTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ClickFeedback
  ) extends zio.aws.kendra.model.ClickFeedback.ReadOnly {
    override val resultId: ResultId =
      zio.aws.kendra.model.primitives.ResultId(impl.resultId())
    override val clickTime: Timestamp =
      zio.aws.kendra.model.primitives.Timestamp(impl.clickTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ClickFeedback
  ): zio.aws.kendra.model.ClickFeedback.ReadOnly = new Wrapper(impl)
}
