package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.ConfluenceSpaceIdentifier
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConfluenceSpaceConfiguration(
    crawlPersonalSpaces: Optional[Boolean] = Optional.Absent,
    crawlArchivedSpaces: Optional[Boolean] = Optional.Absent,
    includeSpaces: Optional[Iterable[ConfluenceSpaceIdentifier]] =
      Optional.Absent,
    excludeSpaces: Optional[Iterable[ConfluenceSpaceIdentifier]] =
      Optional.Absent,
    spaceFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.ConfluenceSpaceToIndexFieldMapping]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ConfluenceSpaceConfiguration = {
    import ConfluenceSpaceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ConfluenceSpaceConfiguration
      .builder()
      .optionallyWith(
        crawlPersonalSpaces.map(value => value: java.lang.Boolean)
      )(_.crawlPersonalSpaces)
      .optionallyWith(
        crawlArchivedSpaces.map(value => value: java.lang.Boolean)
      )(_.crawlArchivedSpaces)
      .optionallyWith(
        includeSpaces.map(value =>
          value.map { item =>
            ConfluenceSpaceIdentifier.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.includeSpaces)
      .optionallyWith(
        excludeSpaces.map(value =>
          value.map { item =>
            ConfluenceSpaceIdentifier.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.excludeSpaces)
      .optionallyWith(
        spaceFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.spaceFieldMappings)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ConfluenceSpaceConfiguration.ReadOnly =
    zio.aws.kendra.model.ConfluenceSpaceConfiguration.wrap(buildAwsValue())
}
object ConfluenceSpaceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ConfluenceSpaceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ConfluenceSpaceConfiguration =
      zio.aws.kendra.model.ConfluenceSpaceConfiguration(
        crawlPersonalSpaces.map(value => value),
        crawlArchivedSpaces.map(value => value),
        includeSpaces.map(value => value),
        excludeSpaces.map(value => value),
        spaceFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def crawlPersonalSpaces: Optional[Boolean]
    def crawlArchivedSpaces: Optional[Boolean]
    def includeSpaces: Optional[List[ConfluenceSpaceIdentifier]]
    def excludeSpaces: Optional[List[ConfluenceSpaceIdentifier]]
    def spaceFieldMappings: Optional[
      List[zio.aws.kendra.model.ConfluenceSpaceToIndexFieldMapping.ReadOnly]
    ]
    def getCrawlPersonalSpaces: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crawlPersonalSpaces", crawlPersonalSpaces)
    def getCrawlArchivedSpaces: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crawlArchivedSpaces", crawlArchivedSpaces)
    def getIncludeSpaces: ZIO[Any, AwsError, List[ConfluenceSpaceIdentifier]] =
      AwsError.unwrapOptionField("includeSpaces", includeSpaces)
    def getExcludeSpaces: ZIO[Any, AwsError, List[ConfluenceSpaceIdentifier]] =
      AwsError.unwrapOptionField("excludeSpaces", excludeSpaces)
    def getSpaceFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.ConfluenceSpaceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("spaceFieldMappings", spaceFieldMappings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ConfluenceSpaceConfiguration
  ) extends zio.aws.kendra.model.ConfluenceSpaceConfiguration.ReadOnly {
    override val crawlPersonalSpaces: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.crawlPersonalSpaces())
      .map(value => value: Boolean)
    override val crawlArchivedSpaces: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.crawlArchivedSpaces())
      .map(value => value: Boolean)
    override val includeSpaces: Optional[List[ConfluenceSpaceIdentifier]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeSpaces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives.ConfluenceSpaceIdentifier(item)
          }.toList
        )
    override val excludeSpaces: Optional[List[ConfluenceSpaceIdentifier]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludeSpaces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives.ConfluenceSpaceIdentifier(item)
          }.toList
        )
    override val spaceFieldMappings: Optional[
      List[zio.aws.kendra.model.ConfluenceSpaceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.spaceFieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.ConfluenceSpaceToIndexFieldMapping.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ConfluenceSpaceConfiguration
  ): zio.aws.kendra.model.ConfluenceSpaceConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
