package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  ClientTokenName,
  Description,
  AccessControlConfigurationName,
  IndexId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAccessControlConfigurationRequest(
    indexId: IndexId,
    name: AccessControlConfigurationName,
    description: Optional[Description] = Optional.Absent,
    accessControlList: Optional[Iterable[zio.aws.kendra.model.Principal]] =
      Optional.Absent,
    hierarchicalAccessControlList: Optional[
      Iterable[zio.aws.kendra.model.HierarchicalPrincipal]
    ] = Optional.Absent,
    clientToken: Optional[ClientTokenName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.CreateAccessControlConfigurationRequest = {
    import CreateAccessControlConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.CreateAccessControlConfigurationRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .name(AccessControlConfigurationName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        accessControlList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessControlList)
      .optionallyWith(
        hierarchicalAccessControlList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hierarchicalAccessControlList)
      .optionallyWith(
        clientToken.map(value =>
          ClientTokenName.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.CreateAccessControlConfigurationRequest.ReadOnly =
    zio.aws.kendra.model.CreateAccessControlConfigurationRequest
      .wrap(buildAwsValue())
}
object CreateAccessControlConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.CreateAccessControlConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.CreateAccessControlConfigurationRequest =
      zio.aws.kendra.model.CreateAccessControlConfigurationRequest(
        indexId,
        name,
        description.map(value => value),
        accessControlList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        hierarchicalAccessControlList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value)
      )
    def indexId: IndexId
    def name: AccessControlConfigurationName
    def description: Optional[Description]
    def accessControlList
        : Optional[List[zio.aws.kendra.model.Principal.ReadOnly]]
    def hierarchicalAccessControlList
        : Optional[List[zio.aws.kendra.model.HierarchicalPrincipal.ReadOnly]]
    def clientToken: Optional[ClientTokenName]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getName: ZIO[Any, Nothing, AccessControlConfigurationName] =
      ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getAccessControlList
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.Principal.ReadOnly]] =
      AwsError.unwrapOptionField("accessControlList", accessControlList)
    def getHierarchicalAccessControlList: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.HierarchicalPrincipal.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "hierarchicalAccessControlList",
      hierarchicalAccessControlList
    )
    def getClientToken: ZIO[Any, AwsError, ClientTokenName] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.CreateAccessControlConfigurationRequest
  ) extends zio.aws.kendra.model.CreateAccessControlConfigurationRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val name: AccessControlConfigurationName =
      zio.aws.kendra.model.primitives
        .AccessControlConfigurationName(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val accessControlList
        : Optional[List[zio.aws.kendra.model.Principal.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessControlList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.Principal.wrap(item)
          }.toList
        )
    override val hierarchicalAccessControlList
        : Optional[List[zio.aws.kendra.model.HierarchicalPrincipal.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hierarchicalAccessControlList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.HierarchicalPrincipal.wrap(item)
          }.toList
        )
    override val clientToken: Optional[ClientTokenName] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.kendra.model.primitives.ClientTokenName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.CreateAccessControlConfigurationRequest
  ): zio.aws.kendra.model.CreateAccessControlConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
