package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.FaqId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateFaqResponse(id: Optional[FaqId] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.CreateFaqResponse = {
    import CreateFaqResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.CreateFaqResponse
      .builder()
      .optionallyWith(id.map(value => FaqId.unwrap(value): java.lang.String))(
        _.id
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.CreateFaqResponse.ReadOnly =
    zio.aws.kendra.model.CreateFaqResponse.wrap(buildAwsValue())
}
object CreateFaqResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.CreateFaqResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.CreateFaqResponse =
      zio.aws.kendra.model.CreateFaqResponse(id.map(value => value))
    def id: Optional[FaqId]
    def getId: ZIO[Any, AwsError, FaqId] = AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.CreateFaqResponse
  ) extends zio.aws.kendra.model.CreateFaqResponse.ReadOnly {
    override val id: Optional[FaqId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.kendra.model.primitives.FaqId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.CreateFaqResponse
  ): zio.aws.kendra.model.CreateFaqResponse.ReadOnly = new Wrapper(impl)
}
