package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.IndexId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteIndexRequest(id: IndexId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DeleteIndexRequest = {
    import DeleteIndexRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DeleteIndexRequest
      .builder()
      .id(IndexId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DeleteIndexRequest.ReadOnly =
    zio.aws.kendra.model.DeleteIndexRequest.wrap(buildAwsValue())
}
object DeleteIndexRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DeleteIndexRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DeleteIndexRequest =
      zio.aws.kendra.model.DeleteIndexRequest(id)
    def id: IndexId
    def getId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DeleteIndexRequest
  ) extends zio.aws.kendra.model.DeleteIndexRequest.ReadOnly {
    override val id: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DeleteIndexRequest
  ): zio.aws.kendra.model.DeleteIndexRequest.ReadOnly = new Wrapper(impl)
}
