package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{IndexId, ThesaurusId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteThesaurusRequest(id: ThesaurusId, indexId: IndexId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DeleteThesaurusRequest = {
    import DeleteThesaurusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DeleteThesaurusRequest
      .builder()
      .id(ThesaurusId.unwrap(id): java.lang.String)
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DeleteThesaurusRequest.ReadOnly =
    zio.aws.kendra.model.DeleteThesaurusRequest.wrap(buildAwsValue())
}
object DeleteThesaurusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DeleteThesaurusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DeleteThesaurusRequest =
      zio.aws.kendra.model.DeleteThesaurusRequest(id, indexId)
    def id: ThesaurusId
    def indexId: IndexId
    def getId: ZIO[Any, Nothing, ThesaurusId] = ZIO.succeed(id)
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DeleteThesaurusRequest
  ) extends zio.aws.kendra.model.DeleteThesaurusRequest.ReadOnly {
    override val id: ThesaurusId =
      zio.aws.kendra.model.primitives.ThesaurusId(impl.id())
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DeleteThesaurusRequest
  ): zio.aws.kendra.model.DeleteThesaurusRequest.ReadOnly = new Wrapper(impl)
}
