package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{AccessControlConfigurationId, IndexId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeAccessControlConfigurationRequest(
    indexId: IndexId,
    id: AccessControlConfigurationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DescribeAccessControlConfigurationRequest = {
    import DescribeAccessControlConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DescribeAccessControlConfigurationRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .id(AccessControlConfigurationId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.DescribeAccessControlConfigurationRequest.ReadOnly =
    zio.aws.kendra.model.DescribeAccessControlConfigurationRequest
      .wrap(buildAwsValue())
}
object DescribeAccessControlConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DescribeAccessControlConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.DescribeAccessControlConfigurationRequest =
      zio.aws.kendra.model
        .DescribeAccessControlConfigurationRequest(indexId, id)
    def indexId: IndexId
    def id: AccessControlConfigurationId
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getId: ZIO[Any, Nothing, AccessControlConfigurationId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DescribeAccessControlConfigurationRequest
  ) extends zio.aws.kendra.model.DescribeAccessControlConfigurationRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val id: AccessControlConfigurationId =
      zio.aws.kendra.model.primitives.AccessControlConfigurationId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DescribeAccessControlConfigurationRequest
  ): zio.aws.kendra.model.DescribeAccessControlConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
