package zio.aws.kendra.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{
  ErrorMessage,
  RoleArn,
  DataSourceName,
  DataSourceId,
  LanguageCode,
  Timestamp,
  IndexId,
  Description,
  ScanSchedule
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeDataSourceResponse(
    id: Optional[DataSourceId] = Optional.Absent,
    indexId: Optional[IndexId] = Optional.Absent,
    name: Optional[DataSourceName] = Optional.Absent,
    `type`: Optional[zio.aws.kendra.model.DataSourceType] = Optional.Absent,
    configuration: Optional[zio.aws.kendra.model.DataSourceConfiguration] =
      Optional.Absent,
    vpcConfiguration: Optional[
      zio.aws.kendra.model.DataSourceVpcConfiguration
    ] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    status: Optional[zio.aws.kendra.model.DataSourceStatus] = Optional.Absent,
    schedule: Optional[ScanSchedule] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent,
    languageCode: Optional[LanguageCode] = Optional.Absent,
    customDocumentEnrichmentConfiguration: Optional[
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DescribeDataSourceResponse = {
    import DescribeDataSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DescribeDataSourceResponse
      .builder()
      .optionallyWith(
        id.map(value => DataSourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        indexId.map(value => IndexId.unwrap(value): java.lang.String)
      )(_.indexId)
      .optionallyWith(
        name.map(value => DataSourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        schedule.map(value => ScanSchedule.unwrap(value): java.lang.String)
      )(_.schedule)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(
        languageCode.map(value => LanguageCode.unwrap(value): java.lang.String)
      )(_.languageCode)
      .optionallyWith(
        customDocumentEnrichmentConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.customDocumentEnrichmentConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DescribeDataSourceResponse.ReadOnly =
    zio.aws.kendra.model.DescribeDataSourceResponse.wrap(buildAwsValue())
}
object DescribeDataSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DescribeDataSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DescribeDataSourceResponse =
      zio.aws.kendra.model.DescribeDataSourceResponse(
        id.map(value => value),
        indexId.map(value => value),
        name.map(value => value),
        `type`.map(value => value),
        configuration.map(value => value.asEditable),
        vpcConfiguration.map(value => value.asEditable),
        createdAt.map(value => value),
        updatedAt.map(value => value),
        description.map(value => value),
        status.map(value => value),
        schedule.map(value => value),
        roleArn.map(value => value),
        errorMessage.map(value => value),
        languageCode.map(value => value),
        customDocumentEnrichmentConfiguration.map(value => value.asEditable)
      )
    def id: Optional[DataSourceId]
    def indexId: Optional[IndexId]
    def name: Optional[DataSourceName]
    def `type`: Optional[zio.aws.kendra.model.DataSourceType]
    def configuration
        : Optional[zio.aws.kendra.model.DataSourceConfiguration.ReadOnly]
    def vpcConfiguration
        : Optional[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly]
    def createdAt: Optional[Timestamp]
    def updatedAt: Optional[Timestamp]
    def description: Optional[Description]
    def status: Optional[zio.aws.kendra.model.DataSourceStatus]
    def schedule: Optional[ScanSchedule]
    def roleArn: Optional[RoleArn]
    def errorMessage: Optional[ErrorMessage]
    def languageCode: Optional[LanguageCode]
    def customDocumentEnrichmentConfiguration: Optional[
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.ReadOnly
    ]
    def getId: ZIO[Any, AwsError, DataSourceId] =
      AwsError.unwrapOptionField("id", id)
    def getIndexId: ZIO[Any, AwsError, IndexId] =
      AwsError.unwrapOptionField("indexId", indexId)
    def getName: ZIO[Any, AwsError, DataSourceName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.kendra.model.DataSourceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DataSourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStatus: ZIO[Any, AwsError, zio.aws.kendra.model.DataSourceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSchedule: ZIO[Any, AwsError, ScanSchedule] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getLanguageCode: ZIO[Any, AwsError, LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getCustomDocumentEnrichmentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "customDocumentEnrichmentConfiguration",
      customDocumentEnrichmentConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DescribeDataSourceResponse
  ) extends zio.aws.kendra.model.DescribeDataSourceResponse.ReadOnly {
    override val id: Optional[DataSourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.kendra.model.primitives.DataSourceId(value))
    override val indexId: Optional[IndexId] = zio.aws.core.internal
      .optionalFromNullable(impl.indexId())
      .map(value => zio.aws.kendra.model.primitives.IndexId(value))
    override val name: Optional[DataSourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.kendra.model.primitives.DataSourceName(value))
    override val `type`: Optional[zio.aws.kendra.model.DataSourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.kendra.model.DataSourceType.wrap(value))
    override val configuration
        : Optional[zio.aws.kendra.model.DataSourceConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value => zio.aws.kendra.model.DataSourceConfiguration.wrap(value))
    override val vpcConfiguration
        : Optional[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfiguration())
        .map(value =>
          zio.aws.kendra.model.DataSourceVpcConfiguration.wrap(value)
        )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val status: Optional[zio.aws.kendra.model.DataSourceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.kendra.model.DataSourceStatus.wrap(value))
    override val schedule: Optional[ScanSchedule] = zio.aws.core.internal
      .optionalFromNullable(impl.schedule())
      .map(value => zio.aws.kendra.model.primitives.ScanSchedule(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.kendra.model.primitives.ErrorMessage(value))
    override val languageCode: Optional[LanguageCode] = zio.aws.core.internal
      .optionalFromNullable(impl.languageCode())
      .map(value => zio.aws.kendra.model.primitives.LanguageCode(value))
    override val customDocumentEnrichmentConfiguration: Optional[
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customDocumentEnrichmentConfiguration())
      .map(value =>
        zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DescribeDataSourceResponse
  ): zio.aws.kendra.model.DescribeDataSourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
