package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{IndexId, FaqId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeFaqRequest(id: FaqId, indexId: IndexId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DescribeFaqRequest = {
    import DescribeFaqRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DescribeFaqRequest
      .builder()
      .id(FaqId.unwrap(id): java.lang.String)
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DescribeFaqRequest.ReadOnly =
    zio.aws.kendra.model.DescribeFaqRequest.wrap(buildAwsValue())
}
object DescribeFaqRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DescribeFaqRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DescribeFaqRequest =
      zio.aws.kendra.model.DescribeFaqRequest(id, indexId)
    def id: FaqId
    def indexId: IndexId
    def getId: ZIO[Any, Nothing, FaqId] = ZIO.succeed(id)
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DescribeFaqRequest
  ) extends zio.aws.kendra.model.DescribeFaqRequest.ReadOnly {
    override val id: FaqId = zio.aws.kendra.model.primitives.FaqId(impl.id())
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DescribeFaqRequest
  ): zio.aws.kendra.model.DescribeFaqRequest.ReadOnly = new Wrapper(impl)
}
