package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.IndexId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeIndexRequest(id: IndexId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DescribeIndexRequest = {
    import DescribeIndexRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DescribeIndexRequest
      .builder()
      .id(IndexId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DescribeIndexRequest.ReadOnly =
    zio.aws.kendra.model.DescribeIndexRequest.wrap(buildAwsValue())
}
object DescribeIndexRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DescribeIndexRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DescribeIndexRequest =
      zio.aws.kendra.model.DescribeIndexRequest(id)
    def id: IndexId
    def getId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DescribeIndexRequest
  ) extends zio.aws.kendra.model.DescribeIndexRequest.ReadOnly {
    override val id: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DescribeIndexRequest
  ): zio.aws.kendra.model.DescribeIndexRequest.ReadOnly = new Wrapper(impl)
}
