package zio.aws.kendra.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{
  MinimumQueryCount,
  ObjectBoolean,
  Timestamp,
  MinimumNumberOfQueryingUsers,
  Integer
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeQuerySuggestionsConfigResponse(
    mode: Optional[zio.aws.kendra.model.Mode] = Optional.Absent,
    status: Optional[zio.aws.kendra.model.QuerySuggestionsStatus] =
      Optional.Absent,
    queryLogLookBackWindowInDays: Optional[Integer] = Optional.Absent,
    includeQueriesWithoutUserInformation: Optional[ObjectBoolean] =
      Optional.Absent,
    minimumNumberOfQueryingUsers: Optional[MinimumNumberOfQueryingUsers] =
      Optional.Absent,
    minimumQueryCount: Optional[MinimumQueryCount] = Optional.Absent,
    lastSuggestionsBuildTime: Optional[Timestamp] = Optional.Absent,
    lastClearTime: Optional[Timestamp] = Optional.Absent,
    totalSuggestionsCount: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsConfigResponse = {
    import DescribeQuerySuggestionsConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsConfigResponse
      .builder()
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        queryLogLookBackWindowInDays.map(value => value: java.lang.Integer)
      )(_.queryLogLookBackWindowInDays)
      .optionallyWith(
        includeQueriesWithoutUserInformation.map(value =>
          ObjectBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.includeQueriesWithoutUserInformation)
      .optionallyWith(
        minimumNumberOfQueryingUsers.map(value =>
          MinimumNumberOfQueryingUsers.unwrap(value): java.lang.Integer
        )
      )(_.minimumNumberOfQueryingUsers)
      .optionallyWith(
        minimumQueryCount.map(value =>
          MinimumQueryCount.unwrap(value): java.lang.Integer
        )
      )(_.minimumQueryCount)
      .optionallyWith(
        lastSuggestionsBuildTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastSuggestionsBuildTime)
      .optionallyWith(
        lastClearTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastClearTime)
      .optionallyWith(
        totalSuggestionsCount.map(value => value: java.lang.Integer)
      )(_.totalSuggestionsCount)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.DescribeQuerySuggestionsConfigResponse.ReadOnly =
    zio.aws.kendra.model.DescribeQuerySuggestionsConfigResponse
      .wrap(buildAwsValue())
}
object DescribeQuerySuggestionsConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.DescribeQuerySuggestionsConfigResponse =
      zio.aws.kendra.model.DescribeQuerySuggestionsConfigResponse(
        mode.map(value => value),
        status.map(value => value),
        queryLogLookBackWindowInDays.map(value => value),
        includeQueriesWithoutUserInformation.map(value => value),
        minimumNumberOfQueryingUsers.map(value => value),
        minimumQueryCount.map(value => value),
        lastSuggestionsBuildTime.map(value => value),
        lastClearTime.map(value => value),
        totalSuggestionsCount.map(value => value)
      )
    def mode: Optional[zio.aws.kendra.model.Mode]
    def status: Optional[zio.aws.kendra.model.QuerySuggestionsStatus]
    def queryLogLookBackWindowInDays: Optional[Integer]
    def includeQueriesWithoutUserInformation: Optional[ObjectBoolean]
    def minimumNumberOfQueryingUsers: Optional[MinimumNumberOfQueryingUsers]
    def minimumQueryCount: Optional[MinimumQueryCount]
    def lastSuggestionsBuildTime: Optional[Timestamp]
    def lastClearTime: Optional[Timestamp]
    def totalSuggestionsCount: Optional[Integer]
    def getMode: ZIO[Any, AwsError, zio.aws.kendra.model.Mode] =
      AwsError.unwrapOptionField("mode", mode)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.kendra.model.QuerySuggestionsStatus] =
      AwsError.unwrapOptionField("status", status)
    def getQueryLogLookBackWindowInDays: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "queryLogLookBackWindowInDays",
        queryLogLookBackWindowInDays
      )
    def getIncludeQueriesWithoutUserInformation
        : ZIO[Any, AwsError, ObjectBoolean] = AwsError.unwrapOptionField(
      "includeQueriesWithoutUserInformation",
      includeQueriesWithoutUserInformation
    )
    def getMinimumNumberOfQueryingUsers
        : ZIO[Any, AwsError, MinimumNumberOfQueryingUsers] =
      AwsError.unwrapOptionField(
        "minimumNumberOfQueryingUsers",
        minimumNumberOfQueryingUsers
      )
    def getMinimumQueryCount: ZIO[Any, AwsError, MinimumQueryCount] =
      AwsError.unwrapOptionField("minimumQueryCount", minimumQueryCount)
    def getLastSuggestionsBuildTime: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastSuggestionsBuildTime", lastSuggestionsBuildTime)
    def getLastClearTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastClearTime", lastClearTime)
    def getTotalSuggestionsCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalSuggestionsCount", totalSuggestionsCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsConfigResponse
  ) extends zio.aws.kendra.model.DescribeQuerySuggestionsConfigResponse.ReadOnly {
    override val mode: Optional[zio.aws.kendra.model.Mode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.kendra.model.Mode.wrap(value))
    override val status: Optional[zio.aws.kendra.model.QuerySuggestionsStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.kendra.model.QuerySuggestionsStatus.wrap(value))
    override val queryLogLookBackWindowInDays: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryLogLookBackWindowInDays())
        .map(value => value: Integer)
    override val includeQueriesWithoutUserInformation: Optional[ObjectBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeQueriesWithoutUserInformation())
        .map(value => zio.aws.kendra.model.primitives.ObjectBoolean(value))
    override val minimumNumberOfQueryingUsers
        : Optional[MinimumNumberOfQueryingUsers] = zio.aws.core.internal
      .optionalFromNullable(impl.minimumNumberOfQueryingUsers())
      .map(value =>
        zio.aws.kendra.model.primitives.MinimumNumberOfQueryingUsers(value)
      )
    override val minimumQueryCount: Optional[MinimumQueryCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minimumQueryCount())
        .map(value => zio.aws.kendra.model.primitives.MinimumQueryCount(value))
    override val lastSuggestionsBuildTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSuggestionsBuildTime())
        .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val lastClearTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastClearTime())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val totalSuggestionsCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalSuggestionsCount())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsConfigResponse
  ): zio.aws.kendra.model.DescribeQuerySuggestionsConfigResponse.ReadOnly =
    new Wrapper(impl)
}
