package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.DocumentAttributeKey
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DocumentAttribute(
    key: DocumentAttributeKey,
    value: zio.aws.kendra.model.DocumentAttributeValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DocumentAttribute = {
    import DocumentAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DocumentAttribute
      .builder()
      .key(DocumentAttributeKey.unwrap(key): java.lang.String)
      .value(value.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DocumentAttribute.ReadOnly =
    zio.aws.kendra.model.DocumentAttribute.wrap(buildAwsValue())
}
object DocumentAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DocumentAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DocumentAttribute =
      zio.aws.kendra.model.DocumentAttribute(key, value.asEditable)
    def key: DocumentAttributeKey
    def value: zio.aws.kendra.model.DocumentAttributeValue.ReadOnly
    def getKey: ZIO[Any, Nothing, DocumentAttributeKey] = ZIO.succeed(key)
    def getValue: ZIO[
      Any,
      Nothing,
      zio.aws.kendra.model.DocumentAttributeValue.ReadOnly
    ] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DocumentAttribute
  ) extends zio.aws.kendra.model.DocumentAttribute.ReadOnly {
    override val key: DocumentAttributeKey =
      zio.aws.kendra.model.primitives.DocumentAttributeKey(impl.key())
    override val value: zio.aws.kendra.model.DocumentAttributeValue.ReadOnly =
      zio.aws.kendra.model.DocumentAttributeValue.wrap(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DocumentAttribute
  ): zio.aws.kendra.model.DocumentAttribute.ReadOnly = new Wrapper(impl)
}
