package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait DocumentAttributeValueType {
  def unwrap
      : software.amazon.awssdk.services.kendra.model.DocumentAttributeValueType
}
object DocumentAttributeValueType {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.DocumentAttributeValueType
  ): zio.aws.kendra.model.DocumentAttributeValueType = value match {
    case software.amazon.awssdk.services.kendra.model.DocumentAttributeValueType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.DocumentAttributeValueType.STRING_VALUE =>
      val r = STRING_VALUE
      r
    case software.amazon.awssdk.services.kendra.model.DocumentAttributeValueType.STRING_LIST_VALUE =>
      val r = STRING_LIST_VALUE
      r
    case software.amazon.awssdk.services.kendra.model.DocumentAttributeValueType.LONG_VALUE =>
      val r = LONG_VALUE
      r
    case software.amazon.awssdk.services.kendra.model.DocumentAttributeValueType.DATE_VALUE =>
      val r = DATE_VALUE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kendra.model.DocumentAttributeValueType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DocumentAttributeValueType =
      software.amazon.awssdk.services.kendra.model.DocumentAttributeValueType.UNKNOWN_TO_SDK_VERSION
  }
  case object STRING_VALUE
      extends zio.aws.kendra.model.DocumentAttributeValueType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DocumentAttributeValueType =
      software.amazon.awssdk.services.kendra.model.DocumentAttributeValueType.STRING_VALUE
  }
  case object STRING_LIST_VALUE
      extends zio.aws.kendra.model.DocumentAttributeValueType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DocumentAttributeValueType =
      software.amazon.awssdk.services.kendra.model.DocumentAttributeValueType.STRING_LIST_VALUE
  }
  case object LONG_VALUE
      extends zio.aws.kendra.model.DocumentAttributeValueType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DocumentAttributeValueType =
      software.amazon.awssdk.services.kendra.model.DocumentAttributeValueType.LONG_VALUE
  }
  case object DATE_VALUE
      extends zio.aws.kendra.model.DocumentAttributeValueType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DocumentAttributeValueType =
      software.amazon.awssdk.services.kendra.model.DocumentAttributeValueType.DATE_VALUE
  }
}
