package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.NameType
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EntityDisplayData(
    userName: Optional[NameType] = Optional.Absent,
    groupName: Optional[NameType] = Optional.Absent,
    identifiedUserName: Optional[NameType] = Optional.Absent,
    firstName: Optional[NameType] = Optional.Absent,
    lastName: Optional[NameType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.EntityDisplayData = {
    import EntityDisplayData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.EntityDisplayData
      .builder()
      .optionallyWith(
        userName.map(value => NameType.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(
        groupName.map(value => NameType.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        identifiedUserName.map(value =>
          NameType.unwrap(value): java.lang.String
        )
      )(_.identifiedUserName)
      .optionallyWith(
        firstName.map(value => NameType.unwrap(value): java.lang.String)
      )(_.firstName)
      .optionallyWith(
        lastName.map(value => NameType.unwrap(value): java.lang.String)
      )(_.lastName)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.EntityDisplayData.ReadOnly =
    zio.aws.kendra.model.EntityDisplayData.wrap(buildAwsValue())
}
object EntityDisplayData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.EntityDisplayData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.EntityDisplayData =
      zio.aws.kendra.model.EntityDisplayData(
        userName.map(value => value),
        groupName.map(value => value),
        identifiedUserName.map(value => value),
        firstName.map(value => value),
        lastName.map(value => value)
      )
    def userName: Optional[NameType]
    def groupName: Optional[NameType]
    def identifiedUserName: Optional[NameType]
    def firstName: Optional[NameType]
    def lastName: Optional[NameType]
    def getUserName: ZIO[Any, AwsError, NameType] =
      AwsError.unwrapOptionField("userName", userName)
    def getGroupName: ZIO[Any, AwsError, NameType] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getIdentifiedUserName: ZIO[Any, AwsError, NameType] =
      AwsError.unwrapOptionField("identifiedUserName", identifiedUserName)
    def getFirstName: ZIO[Any, AwsError, NameType] =
      AwsError.unwrapOptionField("firstName", firstName)
    def getLastName: ZIO[Any, AwsError, NameType] =
      AwsError.unwrapOptionField("lastName", lastName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.EntityDisplayData
  ) extends zio.aws.kendra.model.EntityDisplayData.ReadOnly {
    override val userName: Optional[NameType] = zio.aws.core.internal
      .optionalFromNullable(impl.userName())
      .map(value => zio.aws.kendra.model.primitives.NameType(value))
    override val groupName: Optional[NameType] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.kendra.model.primitives.NameType(value))
    override val identifiedUserName: Optional[NameType] = zio.aws.core.internal
      .optionalFromNullable(impl.identifiedUserName())
      .map(value => zio.aws.kendra.model.primitives.NameType(value))
    override val firstName: Optional[NameType] = zio.aws.core.internal
      .optionalFromNullable(impl.firstName())
      .map(value => zio.aws.kendra.model.primitives.NameType(value))
    override val lastName: Optional[NameType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastName())
      .map(value => zio.aws.kendra.model.primitives.NameType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.EntityDisplayData
  ): zio.aws.kendra.model.EntityDisplayData.ReadOnly = new Wrapper(impl)
}
