package zio.aws.kendra.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{Timestamp, ExperienceId, ExperienceName}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ExperiencesSummary(
    name: Optional[ExperienceName] = Optional.Absent,
    id: Optional[ExperienceId] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    status: Optional[zio.aws.kendra.model.ExperienceStatus] = Optional.Absent,
    endpoints: Optional[Iterable[zio.aws.kendra.model.ExperienceEndpoint]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ExperiencesSummary = {
    import ExperiencesSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ExperiencesSummary
      .builder()
      .optionallyWith(
        name.map(value => ExperienceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        id.map(value => ExperienceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        endpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpoints)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ExperiencesSummary.ReadOnly =
    zio.aws.kendra.model.ExperiencesSummary.wrap(buildAwsValue())
}
object ExperiencesSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ExperiencesSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ExperiencesSummary =
      zio.aws.kendra.model.ExperiencesSummary(
        name.map(value => value),
        id.map(value => value),
        createdAt.map(value => value),
        status.map(value => value),
        endpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Optional[ExperienceName]
    def id: Optional[ExperienceId]
    def createdAt: Optional[Timestamp]
    def status: Optional[zio.aws.kendra.model.ExperienceStatus]
    def endpoints
        : Optional[List[zio.aws.kendra.model.ExperienceEndpoint.ReadOnly]]
    def getName: ZIO[Any, AwsError, ExperienceName] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, ExperienceId] =
      AwsError.unwrapOptionField("id", id)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getStatus: ZIO[Any, AwsError, zio.aws.kendra.model.ExperienceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getEndpoints: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.ExperienceEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("endpoints", endpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ExperiencesSummary
  ) extends zio.aws.kendra.model.ExperiencesSummary.ReadOnly {
    override val name: Optional[ExperienceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.kendra.model.primitives.ExperienceName(value))
    override val id: Optional[ExperienceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.kendra.model.primitives.ExperienceId(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val status: Optional[zio.aws.kendra.model.ExperienceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.kendra.model.ExperienceStatus.wrap(value))
    override val endpoints
        : Optional[List[zio.aws.kendra.model.ExperienceEndpoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.ExperienceEndpoint.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ExperiencesSummary
  ): zio.aws.kendra.model.ExperiencesSummary.ReadOnly = new Wrapper(impl)
}
