package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.DocumentAttributeKey
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FacetResult(
    documentAttributeKey: Optional[DocumentAttributeKey] = Optional.Absent,
    documentAttributeValueType: Optional[
      zio.aws.kendra.model.DocumentAttributeValueType
    ] = Optional.Absent,
    documentAttributeValueCountPairs: Optional[
      Iterable[zio.aws.kendra.model.DocumentAttributeValueCountPair]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.FacetResult = {
    import FacetResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.FacetResult
      .builder()
      .optionallyWith(
        documentAttributeKey.map(value =>
          DocumentAttributeKey.unwrap(value): java.lang.String
        )
      )(_.documentAttributeKey)
      .optionallyWith(documentAttributeValueType.map(value => value.unwrap))(
        _.documentAttributeValueType
      )
      .optionallyWith(
        documentAttributeValueCountPairs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentAttributeValueCountPairs)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.FacetResult.ReadOnly =
    zio.aws.kendra.model.FacetResult.wrap(buildAwsValue())
}
object FacetResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.FacetResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.FacetResult =
      zio.aws.kendra.model.FacetResult(
        documentAttributeKey.map(value => value),
        documentAttributeValueType.map(value => value),
        documentAttributeValueCountPairs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def documentAttributeKey: Optional[DocumentAttributeKey]
    def documentAttributeValueType
        : Optional[zio.aws.kendra.model.DocumentAttributeValueType]
    def documentAttributeValueCountPairs: Optional[
      List[zio.aws.kendra.model.DocumentAttributeValueCountPair.ReadOnly]
    ]
    def getDocumentAttributeKey: ZIO[Any, AwsError, DocumentAttributeKey] =
      AwsError.unwrapOptionField("documentAttributeKey", documentAttributeKey)
    def getDocumentAttributeValueType
        : ZIO[Any, AwsError, zio.aws.kendra.model.DocumentAttributeValueType] =
      AwsError.unwrapOptionField(
        "documentAttributeValueType",
        documentAttributeValueType
      )
    def getDocumentAttributeValueCountPairs: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DocumentAttributeValueCountPair.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "documentAttributeValueCountPairs",
      documentAttributeValueCountPairs
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.FacetResult
  ) extends zio.aws.kendra.model.FacetResult.ReadOnly {
    override val documentAttributeKey: Optional[DocumentAttributeKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentAttributeKey())
        .map(value =>
          zio.aws.kendra.model.primitives.DocumentAttributeKey(value)
        )
    override val documentAttributeValueType
        : Optional[zio.aws.kendra.model.DocumentAttributeValueType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentAttributeValueType())
        .map(value =>
          zio.aws.kendra.model.DocumentAttributeValueType.wrap(value)
        )
    override val documentAttributeValueCountPairs: Optional[
      List[zio.aws.kendra.model.DocumentAttributeValueCountPair.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.documentAttributeValueCountPairs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DocumentAttributeValueCountPair.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.FacetResult
  ): zio.aws.kendra.model.FacetResult.ReadOnly = new Wrapper(impl)
}
