package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.QuerySuggestionsId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetQuerySuggestionsResponse(
    querySuggestionsId: Optional[QuerySuggestionsId] = Optional.Absent,
    suggestions: Optional[Iterable[zio.aws.kendra.model.Suggestion]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsResponse = {
    import GetQuerySuggestionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsResponse
      .builder()
      .optionallyWith(
        querySuggestionsId.map(value =>
          QuerySuggestionsId.unwrap(value): java.lang.String
        )
      )(_.querySuggestionsId)
      .optionallyWith(
        suggestions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.suggestions)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.GetQuerySuggestionsResponse.ReadOnly =
    zio.aws.kendra.model.GetQuerySuggestionsResponse.wrap(buildAwsValue())
}
object GetQuerySuggestionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.GetQuerySuggestionsResponse =
      zio.aws.kendra.model.GetQuerySuggestionsResponse(
        querySuggestionsId.map(value => value),
        suggestions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def querySuggestionsId: Optional[QuerySuggestionsId]
    def suggestions: Optional[List[zio.aws.kendra.model.Suggestion.ReadOnly]]
    def getQuerySuggestionsId: ZIO[Any, AwsError, QuerySuggestionsId] =
      AwsError.unwrapOptionField("querySuggestionsId", querySuggestionsId)
    def getSuggestions
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.Suggestion.ReadOnly]] =
      AwsError.unwrapOptionField("suggestions", suggestions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsResponse
  ) extends zio.aws.kendra.model.GetQuerySuggestionsResponse.ReadOnly {
    override val querySuggestionsId: Optional[QuerySuggestionsId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.querySuggestionsId())
        .map(value => zio.aws.kendra.model.primitives.QuerySuggestionsId(value))
    override val suggestions
        : Optional[List[zio.aws.kendra.model.Suggestion.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suggestions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.Suggestion.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsResponse
  ): zio.aws.kendra.model.GetQuerySuggestionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
