package zio.aws.kendra.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{Timestamp, IndexId, IndexName}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class IndexConfigurationSummary(
    name: Optional[IndexName] = Optional.Absent,
    id: Optional[IndexId] = Optional.Absent,
    edition: Optional[zio.aws.kendra.model.IndexEdition] = Optional.Absent,
    createdAt: Timestamp,
    updatedAt: Timestamp,
    status: zio.aws.kendra.model.IndexStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.IndexConfigurationSummary = {
    import IndexConfigurationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.IndexConfigurationSummary
      .builder()
      .optionallyWith(
        name.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(id.map(value => IndexId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(edition.map(value => value.unwrap))(_.edition)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .updatedAt(Timestamp.unwrap(updatedAt): Instant)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.IndexConfigurationSummary.ReadOnly =
    zio.aws.kendra.model.IndexConfigurationSummary.wrap(buildAwsValue())
}
object IndexConfigurationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.IndexConfigurationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.IndexConfigurationSummary =
      zio.aws.kendra.model.IndexConfigurationSummary(
        name.map(value => value),
        id.map(value => value),
        edition.map(value => value),
        createdAt,
        updatedAt,
        status
      )
    def name: Optional[IndexName]
    def id: Optional[IndexId]
    def edition: Optional[zio.aws.kendra.model.IndexEdition]
    def createdAt: Timestamp
    def updatedAt: Timestamp
    def status: zio.aws.kendra.model.IndexStatus
    def getName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, IndexId] =
      AwsError.unwrapOptionField("id", id)
    def getEdition: ZIO[Any, AwsError, zio.aws.kendra.model.IndexEdition] =
      AwsError.unwrapOptionField("edition", edition)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getUpdatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updatedAt)
    def getStatus: ZIO[Any, Nothing, zio.aws.kendra.model.IndexStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.IndexConfigurationSummary
  ) extends zio.aws.kendra.model.IndexConfigurationSummary.ReadOnly {
    override val name: Optional[IndexName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.kendra.model.primitives.IndexName(value))
    override val id: Optional[IndexId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.kendra.model.primitives.IndexId(value))
    override val edition: Optional[zio.aws.kendra.model.IndexEdition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.edition())
        .map(value => zio.aws.kendra.model.IndexEdition.wrap(value))
    override val createdAt: Timestamp =
      zio.aws.kendra.model.primitives.Timestamp(impl.createdAt())
    override val updatedAt: Timestamp =
      zio.aws.kendra.model.primitives.Timestamp(impl.updatedAt())
    override val status: zio.aws.kendra.model.IndexStatus =
      zio.aws.kendra.model.IndexStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.IndexConfigurationSummary
  ): zio.aws.kendra.model.IndexConfigurationSummary.ReadOnly = new Wrapper(impl)
}
