package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait Interval {
  def unwrap: software.amazon.awssdk.services.kendra.model.Interval
}
object Interval {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.Interval
  ): zio.aws.kendra.model.Interval = value match {
    case software.amazon.awssdk.services.kendra.model.Interval.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.Interval.THIS_MONTH =>
      val r = THIS_MONTH
      r
    case software.amazon.awssdk.services.kendra.model.Interval.THIS_WEEK =>
      val r = THIS_WEEK
      r
    case software.amazon.awssdk.services.kendra.model.Interval.ONE_WEEK_AGO =>
      val r = ONE_WEEK_AGO
      r
    case software.amazon.awssdk.services.kendra.model.Interval.TWO_WEEKS_AGO =>
      val r = TWO_WEEKS_AGO
      r
    case software.amazon.awssdk.services.kendra.model.Interval.ONE_MONTH_AGO =>
      val r = ONE_MONTH_AGO
      r
    case software.amazon.awssdk.services.kendra.model.Interval.TWO_MONTHS_AGO =>
      val r = TWO_MONTHS_AGO
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.Interval {
    override def unwrap: software.amazon.awssdk.services.kendra.model.Interval =
      software.amazon.awssdk.services.kendra.model.Interval.UNKNOWN_TO_SDK_VERSION
  }
  case object THIS_MONTH extends zio.aws.kendra.model.Interval {
    override def unwrap: software.amazon.awssdk.services.kendra.model.Interval =
      software.amazon.awssdk.services.kendra.model.Interval.THIS_MONTH
  }
  case object THIS_WEEK extends zio.aws.kendra.model.Interval {
    override def unwrap: software.amazon.awssdk.services.kendra.model.Interval =
      software.amazon.awssdk.services.kendra.model.Interval.THIS_WEEK
  }
  case object ONE_WEEK_AGO extends zio.aws.kendra.model.Interval {
    override def unwrap: software.amazon.awssdk.services.kendra.model.Interval =
      software.amazon.awssdk.services.kendra.model.Interval.ONE_WEEK_AGO
  }
  case object TWO_WEEKS_AGO extends zio.aws.kendra.model.Interval {
    override def unwrap: software.amazon.awssdk.services.kendra.model.Interval =
      software.amazon.awssdk.services.kendra.model.Interval.TWO_WEEKS_AGO
  }
  case object ONE_MONTH_AGO extends zio.aws.kendra.model.Interval {
    override def unwrap: software.amazon.awssdk.services.kendra.model.Interval =
      software.amazon.awssdk.services.kendra.model.Interval.ONE_MONTH_AGO
  }
  case object TWO_MONTHS_AGO extends zio.aws.kendra.model.Interval {
    override def unwrap: software.amazon.awssdk.services.kendra.model.Interval =
      software.amazon.awssdk.services.kendra.model.Interval.TWO_MONTHS_AGO
  }
}
