package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait IssueSubEntity {
  def unwrap: software.amazon.awssdk.services.kendra.model.IssueSubEntity
}
object IssueSubEntity {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.IssueSubEntity
  ): zio.aws.kendra.model.IssueSubEntity = value match {
    case software.amazon.awssdk.services.kendra.model.IssueSubEntity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.IssueSubEntity.COMMENTS =>
      val r = COMMENTS
      r
    case software.amazon.awssdk.services.kendra.model.IssueSubEntity.ATTACHMENTS =>
      val r = ATTACHMENTS
      r
    case software.amazon.awssdk.services.kendra.model.IssueSubEntity.WORKLOGS =>
      val r = WORKLOGS
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.IssueSubEntity {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.IssueSubEntity =
      software.amazon.awssdk.services.kendra.model.IssueSubEntity.UNKNOWN_TO_SDK_VERSION
  }
  case object COMMENTS extends zio.aws.kendra.model.IssueSubEntity {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.IssueSubEntity =
      software.amazon.awssdk.services.kendra.model.IssueSubEntity.COMMENTS
  }
  case object ATTACHMENTS extends zio.aws.kendra.model.IssueSubEntity {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.IssueSubEntity =
      software.amazon.awssdk.services.kendra.model.IssueSubEntity.ATTACHMENTS
  }
  case object WORKLOGS extends zio.aws.kendra.model.IssueSubEntity {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.IssueSubEntity =
      software.amazon.awssdk.services.kendra.model.IssueSubEntity.WORKLOGS
  }
}
