package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAccessControlConfigurationsResponse(
    nextToken: Optional[String] = Optional.Absent,
    accessControlConfigurations: Iterable[
      zio.aws.kendra.model.AccessControlConfigurationSummary
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsResponse = {
    import ListAccessControlConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .accessControlConfigurations(accessControlConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.ListAccessControlConfigurationsResponse.ReadOnly =
    zio.aws.kendra.model.ListAccessControlConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListAccessControlConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.ListAccessControlConfigurationsResponse =
      zio.aws.kendra.model.ListAccessControlConfigurationsResponse(
        nextToken.map(value => value),
        accessControlConfigurations.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[String]
    def accessControlConfigurations
        : List[zio.aws.kendra.model.AccessControlConfigurationSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getAccessControlConfigurations: ZIO[Any, Nothing, List[
      zio.aws.kendra.model.AccessControlConfigurationSummary.ReadOnly
    ]] = ZIO.succeed(accessControlConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsResponse
  ) extends zio.aws.kendra.model.ListAccessControlConfigurationsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val accessControlConfigurations: List[
      zio.aws.kendra.model.AccessControlConfigurationSummary.ReadOnly
    ] = impl
      .accessControlConfigurations()
      .asScala
      .map { item =>
        zio.aws.kendra.model.AccessControlConfigurationSummary.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsResponse
  ): zio.aws.kendra.model.ListAccessControlConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
