package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDataSourceSyncJobsResponse(
    history: Optional[Iterable[zio.aws.kendra.model.DataSourceSyncJob]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsResponse = {
    import ListDataSourceSyncJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsResponse
      .builder()
      .optionallyWith(
        history.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.history)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ListDataSourceSyncJobsResponse.ReadOnly =
    zio.aws.kendra.model.ListDataSourceSyncJobsResponse.wrap(buildAwsValue())
}
object ListDataSourceSyncJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListDataSourceSyncJobsResponse =
      zio.aws.kendra.model.ListDataSourceSyncJobsResponse(
        history.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def history: Optional[List[zio.aws.kendra.model.DataSourceSyncJob.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getHistory: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceSyncJob.ReadOnly
    ]] = AwsError.unwrapOptionField("history", history)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsResponse
  ) extends zio.aws.kendra.model.ListDataSourceSyncJobsResponse.ReadOnly {
    override val history
        : Optional[List[zio.aws.kendra.model.DataSourceSyncJob.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.history())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.DataSourceSyncJob.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsResponse
  ): zio.aws.kendra.model.ListDataSourceSyncJobsResponse.ReadOnly = new Wrapper(
    impl
  )
}
