package zio.aws.kendra.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{
  MaxResultsIntegerForListIndicesRequest,
  NextToken
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListIndicesRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResultsIntegerForListIndicesRequest] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListIndicesRequest = {
    import ListIndicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListIndicesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          MaxResultsIntegerForListIndicesRequest.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ListIndicesRequest.ReadOnly =
    zio.aws.kendra.model.ListIndicesRequest.wrap(buildAwsValue())
}
object ListIndicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListIndicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListIndicesRequest =
      zio.aws.kendra.model.ListIndicesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResultsIntegerForListIndicesRequest]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, MaxResultsIntegerForListIndicesRequest] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListIndicesRequest
  ) extends zio.aws.kendra.model.ListIndicesRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResultsIntegerForListIndicesRequest] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.kendra.model.primitives
            .MaxResultsIntegerForListIndicesRequest(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListIndicesRequest
  ): zio.aws.kendra.model.ListIndicesRequest.ReadOnly = new Wrapper(impl)
}
