package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListIndicesResponse(
    indexConfigurationSummaryItems: Optional[
      Iterable[zio.aws.kendra.model.IndexConfigurationSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListIndicesResponse = {
    import ListIndicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListIndicesResponse
      .builder()
      .optionallyWith(
        indexConfigurationSummaryItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.indexConfigurationSummaryItems)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ListIndicesResponse.ReadOnly =
    zio.aws.kendra.model.ListIndicesResponse.wrap(buildAwsValue())
}
object ListIndicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListIndicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListIndicesResponse =
      zio.aws.kendra.model.ListIndicesResponse(
        indexConfigurationSummaryItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def indexConfigurationSummaryItems: Optional[
      List[zio.aws.kendra.model.IndexConfigurationSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getIndexConfigurationSummaryItems: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.IndexConfigurationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "indexConfigurationSummaryItems",
      indexConfigurationSummaryItems
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListIndicesResponse
  ) extends zio.aws.kendra.model.ListIndicesResponse.ReadOnly {
    override val indexConfigurationSummaryItems: Optional[
      List[zio.aws.kendra.model.IndexConfigurationSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.indexConfigurationSummaryItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.IndexConfigurationSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListIndicesResponse
  ): zio.aws.kendra.model.ListIndicesResponse.ReadOnly = new Wrapper(impl)
}
