package zio.aws.kendra.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{
  MaxResultsIntegerForListQuerySuggestionsBlockLists,
  NextToken,
  IndexId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListQuerySuggestionsBlockListsRequest(
    indexId: IndexId,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResultsIntegerForListQuerySuggestionsBlockLists] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsRequest = {
    import ListQuerySuggestionsBlockListsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          MaxResultsIntegerForListQuerySuggestionsBlockLists.unwrap(
            value
          ): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.ListQuerySuggestionsBlockListsRequest.ReadOnly =
    zio.aws.kendra.model.ListQuerySuggestionsBlockListsRequest
      .wrap(buildAwsValue())
}
object ListQuerySuggestionsBlockListsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListQuerySuggestionsBlockListsRequest =
      zio.aws.kendra.model.ListQuerySuggestionsBlockListsRequest(
        indexId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def indexId: IndexId
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResultsIntegerForListQuerySuggestionsBlockLists]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[
      Any,
      AwsError,
      MaxResultsIntegerForListQuerySuggestionsBlockLists
    ] = AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsRequest
  ) extends zio.aws.kendra.model.ListQuerySuggestionsBlockListsRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
    override val maxResults
        : Optional[MaxResultsIntegerForListQuerySuggestionsBlockLists] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.kendra.model.primitives
            .MaxResultsIntegerForListQuerySuggestionsBlockLists(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListQuerySuggestionsBlockListsRequest
  ): zio.aws.kendra.model.ListQuerySuggestionsBlockListsRequest.ReadOnly =
    new Wrapper(impl)
}
