package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{DataSourceId, GroupId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MemberGroup(
    groupId: GroupId,
    dataSourceId: Optional[DataSourceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.MemberGroup = {
    import MemberGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.MemberGroup
      .builder()
      .groupId(GroupId.unwrap(groupId): java.lang.String)
      .optionallyWith(
        dataSourceId.map(value => DataSourceId.unwrap(value): java.lang.String)
      )(_.dataSourceId)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.MemberGroup.ReadOnly =
    zio.aws.kendra.model.MemberGroup.wrap(buildAwsValue())
}
object MemberGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.MemberGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.MemberGroup = zio.aws.kendra.model
      .MemberGroup(groupId, dataSourceId.map(value => value))
    def groupId: GroupId
    def dataSourceId: Optional[DataSourceId]
    def getGroupId: ZIO[Any, Nothing, GroupId] = ZIO.succeed(groupId)
    def getDataSourceId: ZIO[Any, AwsError, DataSourceId] =
      AwsError.unwrapOptionField("dataSourceId", dataSourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.MemberGroup
  ) extends zio.aws.kendra.model.MemberGroup.ReadOnly {
    override val groupId: GroupId =
      zio.aws.kendra.model.primitives.GroupId(impl.groupId())
    override val dataSourceId: Optional[DataSourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSourceId())
      .map(value => zio.aws.kendra.model.primitives.DataSourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.MemberGroup
  ): zio.aws.kendra.model.MemberGroup.ReadOnly = new Wrapper(impl)
}
