package zio.aws.kendra.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{Timestamp, EntityId}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class PersonasSummary(
    entityId: Optional[EntityId] = Optional.Absent,
    persona: Optional[zio.aws.kendra.model.Persona] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.PersonasSummary = {
    import PersonasSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.PersonasSummary
      .builder()
      .optionallyWith(
        entityId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.entityId)
      .optionallyWith(persona.map(value => value.unwrap))(_.persona)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.PersonasSummary.ReadOnly =
    zio.aws.kendra.model.PersonasSummary.wrap(buildAwsValue())
}
object PersonasSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.PersonasSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.PersonasSummary =
      zio.aws.kendra.model.PersonasSummary(
        entityId.map(value => value),
        persona.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value)
      )
    def entityId: Optional[EntityId]
    def persona: Optional[zio.aws.kendra.model.Persona]
    def createdAt: Optional[Timestamp]
    def updatedAt: Optional[Timestamp]
    def getEntityId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("entityId", entityId)
    def getPersona: ZIO[Any, AwsError, zio.aws.kendra.model.Persona] =
      AwsError.unwrapOptionField("persona", persona)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.PersonasSummary
  ) extends zio.aws.kendra.model.PersonasSummary.ReadOnly {
    override val entityId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.entityId())
      .map(value => zio.aws.kendra.model.primitives.EntityId(value))
    override val persona: Optional[zio.aws.kendra.model.Persona] =
      zio.aws.core.internal
        .optionalFromNullable(impl.persona())
        .map(value => zio.aws.kendra.model.Persona.wrap(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.PersonasSummary
  ): zio.aws.kendra.model.PersonasSummary.ReadOnly = new Wrapper(impl)
}
