package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait QueryResultFormat {
  def unwrap: software.amazon.awssdk.services.kendra.model.QueryResultFormat
}
object QueryResultFormat {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.QueryResultFormat
  ): zio.aws.kendra.model.QueryResultFormat = value match {
    case software.amazon.awssdk.services.kendra.model.QueryResultFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.QueryResultFormat.TABLE =>
      val r = TABLE
      r
    case software.amazon.awssdk.services.kendra.model.QueryResultFormat.TEXT =>
      val r = TEXT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kendra.model.QueryResultFormat {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.QueryResultFormat =
      software.amazon.awssdk.services.kendra.model.QueryResultFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object TABLE extends zio.aws.kendra.model.QueryResultFormat {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.QueryResultFormat =
      software.amazon.awssdk.services.kendra.model.QueryResultFormat.TABLE
  }
  case object TEXT extends zio.aws.kendra.model.QueryResultFormat {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.QueryResultFormat =
      software.amazon.awssdk.services.kendra.model.QueryResultFormat.TEXT
  }
}
