package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  DataSourceFieldName,
  SalesforceCustomKnowledgeArticleTypeName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SalesforceCustomKnowledgeArticleTypeConfiguration(
    name: SalesforceCustomKnowledgeArticleTypeName,
    documentDataFieldName: DataSourceFieldName,
    documentTitleFieldName: Optional[DataSourceFieldName] = Optional.Absent,
    fieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.SalesforceCustomKnowledgeArticleTypeConfiguration = {
    import SalesforceCustomKnowledgeArticleTypeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.SalesforceCustomKnowledgeArticleTypeConfiguration
      .builder()
      .name(
        SalesforceCustomKnowledgeArticleTypeName.unwrap(name): java.lang.String
      )
      .documentDataFieldName(
        DataSourceFieldName.unwrap(documentDataFieldName): java.lang.String
      )
      .optionallyWith(
        documentTitleFieldName.map(value =>
          DataSourceFieldName.unwrap(value): java.lang.String
        )
      )(_.documentTitleFieldName)
      .optionallyWith(
        fieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fieldMappings)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.SalesforceCustomKnowledgeArticleTypeConfiguration.ReadOnly =
    zio.aws.kendra.model.SalesforceCustomKnowledgeArticleTypeConfiguration
      .wrap(buildAwsValue())
}
object SalesforceCustomKnowledgeArticleTypeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.SalesforceCustomKnowledgeArticleTypeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.SalesforceCustomKnowledgeArticleTypeConfiguration =
      zio.aws.kendra.model.SalesforceCustomKnowledgeArticleTypeConfiguration(
        name,
        documentDataFieldName,
        documentTitleFieldName.map(value => value),
        fieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: SalesforceCustomKnowledgeArticleTypeName
    def documentDataFieldName: DataSourceFieldName
    def documentTitleFieldName: Optional[DataSourceFieldName]
    def fieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def getName: ZIO[Any, Nothing, SalesforceCustomKnowledgeArticleTypeName] =
      ZIO.succeed(name)
    def getDocumentDataFieldName: ZIO[Any, Nothing, DataSourceFieldName] =
      ZIO.succeed(documentDataFieldName)
    def getDocumentTitleFieldName: ZIO[Any, AwsError, DataSourceFieldName] =
      AwsError.unwrapOptionField(
        "documentTitleFieldName",
        documentTitleFieldName
      )
    def getFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("fieldMappings", fieldMappings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.SalesforceCustomKnowledgeArticleTypeConfiguration
  ) extends zio.aws.kendra.model.SalesforceCustomKnowledgeArticleTypeConfiguration.ReadOnly {
    override val name: SalesforceCustomKnowledgeArticleTypeName =
      zio.aws.kendra.model.primitives
        .SalesforceCustomKnowledgeArticleTypeName(impl.name())
    override val documentDataFieldName: DataSourceFieldName =
      zio.aws.kendra.model.primitives
        .DataSourceFieldName(impl.documentDataFieldName())
    override val documentTitleFieldName: Optional[DataSourceFieldName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentTitleFieldName())
        .map(value =>
          zio.aws.kendra.model.primitives.DataSourceFieldName(value)
        )
    override val fieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.SalesforceCustomKnowledgeArticleTypeConfiguration
  ): zio.aws.kendra.model.SalesforceCustomKnowledgeArticleTypeConfiguration.ReadOnly =
    new Wrapper(impl)
}
