package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait SalesforceStandardObjectName {
  def unwrap: software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName
}
object SalesforceStandardObjectName {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName
  ): zio.aws.kendra.model.SalesforceStandardObjectName = value match {
    case software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.ACCOUNT =>
      val r = ACCOUNT
      r
    case software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.CAMPAIGN =>
      val r = CAMPAIGN
      r
    case software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.CASE =>
      val r = CASE
      r
    case software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.CONTACT =>
      val r = CONTACT
      r
    case software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.CONTRACT =>
      val r = CONTRACT
      r
    case software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.DOCUMENT =>
      val r = DOCUMENT
      r
    case software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.GROUP =>
      val r = GROUP
      r
    case software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.IDEA =>
      val r = IDEA
      r
    case software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.LEAD =>
      val r = LEAD
      r
    case software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.OPPORTUNITY =>
      val r = OPPORTUNITY
      r
    case software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.PARTNER =>
      val r = PARTNER
      r
    case software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.PRICEBOOK =>
      val r = PRICEBOOK
      r
    case software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.PRODUCT =>
      val r = PRODUCT
      r
    case software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.PROFILE =>
      val r = PROFILE
      r
    case software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.SOLUTION =>
      val r = SOLUTION
      r
    case software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.TASK =>
      val r = TASK
      r
    case software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.USER =>
      val r = USER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kendra.model.SalesforceStandardObjectName {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName =
      software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.UNKNOWN_TO_SDK_VERSION
  }
  case object ACCOUNT
      extends zio.aws.kendra.model.SalesforceStandardObjectName {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName =
      software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.ACCOUNT
  }
  case object CAMPAIGN
      extends zio.aws.kendra.model.SalesforceStandardObjectName {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName =
      software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.CAMPAIGN
  }
  case object CASE extends zio.aws.kendra.model.SalesforceStandardObjectName {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName =
      software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.CASE
  }
  case object CONTACT
      extends zio.aws.kendra.model.SalesforceStandardObjectName {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName =
      software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.CONTACT
  }
  case object CONTRACT
      extends zio.aws.kendra.model.SalesforceStandardObjectName {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName =
      software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.CONTRACT
  }
  case object DOCUMENT
      extends zio.aws.kendra.model.SalesforceStandardObjectName {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName =
      software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.DOCUMENT
  }
  case object GROUP extends zio.aws.kendra.model.SalesforceStandardObjectName {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName =
      software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.GROUP
  }
  case object IDEA extends zio.aws.kendra.model.SalesforceStandardObjectName {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName =
      software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.IDEA
  }
  case object LEAD extends zio.aws.kendra.model.SalesforceStandardObjectName {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName =
      software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.LEAD
  }
  case object OPPORTUNITY
      extends zio.aws.kendra.model.SalesforceStandardObjectName {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName =
      software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.OPPORTUNITY
  }
  case object PARTNER
      extends zio.aws.kendra.model.SalesforceStandardObjectName {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName =
      software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.PARTNER
  }
  case object PRICEBOOK
      extends zio.aws.kendra.model.SalesforceStandardObjectName {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName =
      software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.PRICEBOOK
  }
  case object PRODUCT
      extends zio.aws.kendra.model.SalesforceStandardObjectName {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName =
      software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.PRODUCT
  }
  case object PROFILE
      extends zio.aws.kendra.model.SalesforceStandardObjectName {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName =
      software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.PROFILE
  }
  case object SOLUTION
      extends zio.aws.kendra.model.SalesforceStandardObjectName {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName =
      software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.SOLUTION
  }
  case object TASK extends zio.aws.kendra.model.SalesforceStandardObjectName {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName =
      software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.TASK
  }
  case object USER extends zio.aws.kendra.model.SalesforceStandardObjectName {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName =
      software.amazon.awssdk.services.kendra.model.SalesforceStandardObjectName.USER
  }
}
