package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait ThesaurusStatus {
  def unwrap: software.amazon.awssdk.services.kendra.model.ThesaurusStatus
}
object ThesaurusStatus {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.ThesaurusStatus
  ): zio.aws.kendra.model.ThesaurusStatus = value match {
    case software.amazon.awssdk.services.kendra.model.ThesaurusStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.ThesaurusStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.kendra.model.ThesaurusStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.kendra.model.ThesaurusStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.kendra.model.ThesaurusStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.kendra.model.ThesaurusStatus.ACTIVE_BUT_UPDATE_FAILED =>
      val r = ACTIVE_BUT_UPDATE_FAILED
      r
    case software.amazon.awssdk.services.kendra.model.ThesaurusStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.ThesaurusStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ThesaurusStatus =
      software.amazon.awssdk.services.kendra.model.ThesaurusStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.kendra.model.ThesaurusStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ThesaurusStatus =
      software.amazon.awssdk.services.kendra.model.ThesaurusStatus.CREATING
  }
  case object ACTIVE extends zio.aws.kendra.model.ThesaurusStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ThesaurusStatus =
      software.amazon.awssdk.services.kendra.model.ThesaurusStatus.ACTIVE
  }
  case object DELETING extends zio.aws.kendra.model.ThesaurusStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ThesaurusStatus =
      software.amazon.awssdk.services.kendra.model.ThesaurusStatus.DELETING
  }
  case object UPDATING extends zio.aws.kendra.model.ThesaurusStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ThesaurusStatus =
      software.amazon.awssdk.services.kendra.model.ThesaurusStatus.UPDATING
  }
  case object ACTIVE_BUT_UPDATE_FAILED
      extends zio.aws.kendra.model.ThesaurusStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ThesaurusStatus =
      software.amazon.awssdk.services.kendra.model.ThesaurusStatus.ACTIVE_BUT_UPDATE_FAILED
  }
  case object FAILED extends zio.aws.kendra.model.ThesaurusStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ThesaurusStatus =
      software.amazon.awssdk.services.kendra.model.ThesaurusStatus.FAILED
  }
}
