package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait Type {
  def unwrap: software.amazon.awssdk.services.kendra.model.Type
}
object Type {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.Type
  ): zio.aws.kendra.model.Type = value match {
    case software.amazon.awssdk.services.kendra.model.Type.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.Type.SAAS =>
      val r = SAAS
      r
    case software.amazon.awssdk.services.kendra.model.Type.ON_PREMISE =>
      val r = ON_PREMISE
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.Type {
    override def unwrap: software.amazon.awssdk.services.kendra.model.Type =
      software.amazon.awssdk.services.kendra.model.Type.UNKNOWN_TO_SDK_VERSION
  }
  case object SAAS extends zio.aws.kendra.model.Type {
    override def unwrap: software.amazon.awssdk.services.kendra.model.Type =
      software.amazon.awssdk.services.kendra.model.Type.SAAS
  }
  case object ON_PREMISE extends zio.aws.kendra.model.Type {
    override def unwrap: software.amazon.awssdk.services.kendra.model.Type =
      software.amazon.awssdk.services.kendra.model.Type.ON_PREMISE
  }
}
