package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Urls(
    seedUrlConfiguration: Optional[zio.aws.kendra.model.SeedUrlConfiguration] =
      Optional.Absent,
    siteMapsConfiguration: Optional[
      zio.aws.kendra.model.SiteMapsConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.kendra.model.Urls = {
    import Urls.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.Urls
      .builder()
      .optionallyWith(seedUrlConfiguration.map(value => value.buildAwsValue()))(
        _.seedUrlConfiguration
      )
      .optionallyWith(
        siteMapsConfiguration.map(value => value.buildAwsValue())
      )(_.siteMapsConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.Urls.ReadOnly =
    zio.aws.kendra.model.Urls.wrap(buildAwsValue())
}
object Urls {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kendra.model.Urls] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.Urls = zio.aws.kendra.model.Urls(
      seedUrlConfiguration.map(value => value.asEditable),
      siteMapsConfiguration.map(value => value.asEditable)
    )
    def seedUrlConfiguration
        : Optional[zio.aws.kendra.model.SeedUrlConfiguration.ReadOnly]
    def siteMapsConfiguration
        : Optional[zio.aws.kendra.model.SiteMapsConfiguration.ReadOnly]
    def getSeedUrlConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.SeedUrlConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("seedUrlConfiguration", seedUrlConfiguration)
    def getSiteMapsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.SiteMapsConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("siteMapsConfiguration", siteMapsConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.Urls
  ) extends zio.aws.kendra.model.Urls.ReadOnly {
    override val seedUrlConfiguration
        : Optional[zio.aws.kendra.model.SeedUrlConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.seedUrlConfiguration())
        .map(value => zio.aws.kendra.model.SeedUrlConfiguration.wrap(value))
    override val siteMapsConfiguration
        : Optional[zio.aws.kendra.model.SiteMapsConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.siteMapsConfiguration())
        .map(value => zio.aws.kendra.model.SiteMapsConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.Urls
  ): zio.aws.kendra.model.Urls.ReadOnly = new Wrapper(impl)
}
