package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UserTokenConfiguration(
    jwtTokenTypeConfiguration: Optional[
      zio.aws.kendra.model.JwtTokenTypeConfiguration
    ] = Optional.Absent,
    jsonTokenTypeConfiguration: Optional[
      zio.aws.kendra.model.JsonTokenTypeConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.UserTokenConfiguration = {
    import UserTokenConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.UserTokenConfiguration
      .builder()
      .optionallyWith(
        jwtTokenTypeConfiguration.map(value => value.buildAwsValue())
      )(_.jwtTokenTypeConfiguration)
      .optionallyWith(
        jsonTokenTypeConfiguration.map(value => value.buildAwsValue())
      )(_.jsonTokenTypeConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.UserTokenConfiguration.ReadOnly =
    zio.aws.kendra.model.UserTokenConfiguration.wrap(buildAwsValue())
}
object UserTokenConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.UserTokenConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.UserTokenConfiguration =
      zio.aws.kendra.model.UserTokenConfiguration(
        jwtTokenTypeConfiguration.map(value => value.asEditable),
        jsonTokenTypeConfiguration.map(value => value.asEditable)
      )
    def jwtTokenTypeConfiguration
        : Optional[zio.aws.kendra.model.JwtTokenTypeConfiguration.ReadOnly]
    def jsonTokenTypeConfiguration
        : Optional[zio.aws.kendra.model.JsonTokenTypeConfiguration.ReadOnly]
    def getJwtTokenTypeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.JwtTokenTypeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "jwtTokenTypeConfiguration",
      jwtTokenTypeConfiguration
    )
    def getJsonTokenTypeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.JsonTokenTypeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "jsonTokenTypeConfiguration",
      jsonTokenTypeConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.UserTokenConfiguration
  ) extends zio.aws.kendra.model.UserTokenConfiguration.ReadOnly {
    override val jwtTokenTypeConfiguration
        : Optional[zio.aws.kendra.model.JwtTokenTypeConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jwtTokenTypeConfiguration())
        .map(value =>
          zio.aws.kendra.model.JwtTokenTypeConfiguration.wrap(value)
        )
    override val jsonTokenTypeConfiguration
        : Optional[zio.aws.kendra.model.JsonTokenTypeConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jsonTokenTypeConfiguration())
        .map(value =>
          zio.aws.kendra.model.JsonTokenTypeConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.UserTokenConfiguration
  ): zio.aws.kendra.model.UserTokenConfiguration.ReadOnly = new Wrapper(impl)
}
