package zio.aws.kendra.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{
  CrawlDepth,
  MaxLinksPerPage,
  MaxContentSizePerPageInMegaBytes,
  MaxUrlsPerMinuteCrawlRate,
  DataSourceInclusionsExclusionsStringsMember
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class WebCrawlerConfiguration(
    urls: zio.aws.kendra.model.Urls,
    crawlDepth: Optional[CrawlDepth] = Optional.Absent,
    maxLinksPerPage: Optional[MaxLinksPerPage] = Optional.Absent,
    maxContentSizePerPageInMegaBytes: Optional[
      MaxContentSizePerPageInMegaBytes
    ] = Optional.Absent,
    maxUrlsPerMinuteCrawlRate: Optional[MaxUrlsPerMinuteCrawlRate] =
      Optional.Absent,
    urlInclusionPatterns: Optional[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = Optional.Absent,
    urlExclusionPatterns: Optional[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = Optional.Absent,
    proxyConfiguration: Optional[zio.aws.kendra.model.ProxyConfiguration] =
      Optional.Absent,
    authenticationConfiguration: Optional[
      zio.aws.kendra.model.AuthenticationConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.WebCrawlerConfiguration = {
    import WebCrawlerConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.WebCrawlerConfiguration
      .builder()
      .urls(urls.buildAwsValue())
      .optionallyWith(
        crawlDepth.map(value => CrawlDepth.unwrap(value): Integer)
      )(_.crawlDepth)
      .optionallyWith(
        maxLinksPerPage.map(value => MaxLinksPerPage.unwrap(value): Integer)
      )(_.maxLinksPerPage)
      .optionallyWith(
        maxContentSizePerPageInMegaBytes.map(value =>
          MaxContentSizePerPageInMegaBytes.unwrap(value): java.lang.Float
        )
      )(_.maxContentSizePerPageInMegaBytes)
      .optionallyWith(
        maxUrlsPerMinuteCrawlRate.map(value =>
          MaxUrlsPerMinuteCrawlRate.unwrap(value): Integer
        )
      )(_.maxUrlsPerMinuteCrawlRate)
      .optionallyWith(
        urlInclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.urlInclusionPatterns)
      .optionallyWith(
        urlExclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.urlExclusionPatterns)
      .optionallyWith(proxyConfiguration.map(value => value.buildAwsValue()))(
        _.proxyConfiguration
      )
      .optionallyWith(
        authenticationConfiguration.map(value => value.buildAwsValue())
      )(_.authenticationConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.WebCrawlerConfiguration.ReadOnly =
    zio.aws.kendra.model.WebCrawlerConfiguration.wrap(buildAwsValue())
}
object WebCrawlerConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.WebCrawlerConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.WebCrawlerConfiguration =
      zio.aws.kendra.model.WebCrawlerConfiguration(
        urls.asEditable,
        crawlDepth.map(value => value),
        maxLinksPerPage.map(value => value),
        maxContentSizePerPageInMegaBytes.map(value => value),
        maxUrlsPerMinuteCrawlRate.map(value => value),
        urlInclusionPatterns.map(value => value),
        urlExclusionPatterns.map(value => value),
        proxyConfiguration.map(value => value.asEditable),
        authenticationConfiguration.map(value => value.asEditable)
      )
    def urls: zio.aws.kendra.model.Urls.ReadOnly
    def crawlDepth: Optional[CrawlDepth]
    def maxLinksPerPage: Optional[MaxLinksPerPage]
    def maxContentSizePerPageInMegaBytes
        : Optional[MaxContentSizePerPageInMegaBytes]
    def maxUrlsPerMinuteCrawlRate: Optional[MaxUrlsPerMinuteCrawlRate]
    def urlInclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]]
    def urlExclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]]
    def proxyConfiguration
        : Optional[zio.aws.kendra.model.ProxyConfiguration.ReadOnly]
    def authenticationConfiguration
        : Optional[zio.aws.kendra.model.AuthenticationConfiguration.ReadOnly]
    def getUrls: ZIO[Any, Nothing, zio.aws.kendra.model.Urls.ReadOnly] =
      ZIO.succeed(urls)
    def getCrawlDepth: ZIO[Any, AwsError, CrawlDepth] =
      AwsError.unwrapOptionField("crawlDepth", crawlDepth)
    def getMaxLinksPerPage: ZIO[Any, AwsError, MaxLinksPerPage] =
      AwsError.unwrapOptionField("maxLinksPerPage", maxLinksPerPage)
    def getMaxContentSizePerPageInMegaBytes
        : ZIO[Any, AwsError, MaxContentSizePerPageInMegaBytes] =
      AwsError.unwrapOptionField(
        "maxContentSizePerPageInMegaBytes",
        maxContentSizePerPageInMegaBytes
      )
    def getMaxUrlsPerMinuteCrawlRate
        : ZIO[Any, AwsError, MaxUrlsPerMinuteCrawlRate] = AwsError
      .unwrapOptionField("maxUrlsPerMinuteCrawlRate", maxUrlsPerMinuteCrawlRate)
    def getUrlInclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] =
      AwsError.unwrapOptionField("urlInclusionPatterns", urlInclusionPatterns)
    def getUrlExclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] =
      AwsError.unwrapOptionField("urlExclusionPatterns", urlExclusionPatterns)
    def getProxyConfiguration
        : ZIO[Any, AwsError, zio.aws.kendra.model.ProxyConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("proxyConfiguration", proxyConfiguration)
    def getAuthenticationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.AuthenticationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "authenticationConfiguration",
      authenticationConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.WebCrawlerConfiguration
  ) extends zio.aws.kendra.model.WebCrawlerConfiguration.ReadOnly {
    override val urls: zio.aws.kendra.model.Urls.ReadOnly =
      zio.aws.kendra.model.Urls.wrap(impl.urls())
    override val crawlDepth: Optional[CrawlDepth] = zio.aws.core.internal
      .optionalFromNullable(impl.crawlDepth())
      .map(value => zio.aws.kendra.model.primitives.CrawlDepth(value))
    override val maxLinksPerPage: Optional[MaxLinksPerPage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxLinksPerPage())
        .map(value => zio.aws.kendra.model.primitives.MaxLinksPerPage(value))
    override val maxContentSizePerPageInMegaBytes
        : Optional[MaxContentSizePerPageInMegaBytes] = zio.aws.core.internal
      .optionalFromNullable(impl.maxContentSizePerPageInMegaBytes())
      .map(value =>
        zio.aws.kendra.model.primitives.MaxContentSizePerPageInMegaBytes(value)
      )
    override val maxUrlsPerMinuteCrawlRate
        : Optional[MaxUrlsPerMinuteCrawlRate] = zio.aws.core.internal
      .optionalFromNullable(impl.maxUrlsPerMinuteCrawlRate())
      .map(value =>
        zio.aws.kendra.model.primitives.MaxUrlsPerMinuteCrawlRate(value)
      )
    override val urlInclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.urlInclusionPatterns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives
              .DataSourceInclusionsExclusionsStringsMember(item)
          }.toList
        )
    override val urlExclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.urlExclusionPatterns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives
              .DataSourceInclusionsExclusionsStringsMember(item)
          }.toList
        )
    override val proxyConfiguration
        : Optional[zio.aws.kendra.model.ProxyConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proxyConfiguration())
        .map(value => zio.aws.kendra.model.ProxyConfiguration.wrap(value))
    override val authenticationConfiguration
        : Optional[zio.aws.kendra.model.AuthenticationConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationConfiguration())
        .map(value =>
          zio.aws.kendra.model.AuthenticationConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.WebCrawlerConfiguration
  ): zio.aws.kendra.model.WebCrawlerConfiguration.ReadOnly = new Wrapper(impl)
}
