package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.AccessControlConfigurationId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AccessControlConfigurationSummary(
    id: AccessControlConfigurationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.AccessControlConfigurationSummary = {
    import AccessControlConfigurationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.AccessControlConfigurationSummary
      .builder()
      .id(AccessControlConfigurationId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.AccessControlConfigurationSummary.ReadOnly =
    zio.aws.kendra.model.AccessControlConfigurationSummary.wrap(buildAwsValue())
}
object AccessControlConfigurationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.AccessControlConfigurationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.AccessControlConfigurationSummary =
      zio.aws.kendra.model.AccessControlConfigurationSummary(id)
    def id: AccessControlConfigurationId
    def getId: ZIO[Any, Nothing, AccessControlConfigurationId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.AccessControlConfigurationSummary
  ) extends zio.aws.kendra.model.AccessControlConfigurationSummary.ReadOnly {
    override val id: AccessControlConfigurationId =
      zio.aws.kendra.model.primitives.AccessControlConfigurationId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.AccessControlConfigurationSummary
  ): zio.aws.kendra.model.AccessControlConfigurationSummary.ReadOnly =
    new Wrapper(impl)
}
